/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.st.visitors;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.InvocationNode;
import io.resys.hdes.ast.api.nodes.MappingNode;
import io.resys.hdes.ast.api.nodes.ServiceNode;
import io.resys.hdes.ast.api.visitors.ServiceBodyVisitor;
import io.resys.hdes.compiler.spi.spec.HdesDefSpec;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.st.visitors.ImmutableStHeaderSpec;
import io.resys.hdes.compiler.spi.st.visitors.ImmutableStHeadersSpec;
import io.resys.hdes.compiler.spi.st.visitors.StSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import java.util.function.Consumer;
import org.immutables.value.Value;

public class StApiVisitor
implements ServiceBodyVisitor<StSpec, TypeSpec> {
    public TypeSpec visitBody(HdesTree.ServiceTree ctx) {
        CompilerNode.ServiceUnit unit = (CompilerNode.ServiceUnit)ctx.get().node(CompilerNode.ServiceUnit.class);
        CompilerNode.CompilerType compilerType = unit.getType();
        HdesDefSpec.ApiBuilder api = HdesDefSpec.api(compilerType);
        this.visitHeaders(ctx.getValue().getHeaders(), (HdesTree)ctx).getValue().accept(api);
        return api.build().build();
    }

    public StHeadersSpec visitHeaders(BodyNode.Headers node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        Consumer<HdesDefSpec.ApiBuilder> consumer = api -> {
            StHeaderSpec header;
            ImmutableSpec.ImmutableBuilder input = api.inputValue();
            ImmutableSpec.ImmutableBuilder output = api.outputValue();
            for (BodyNode.TypeDef typeDef : node.getAcceptDefs()) {
                header = this.visitHeader(typeDef, next);
                header.getValue().accept(input);
                header.getNested().accept((HdesDefSpec.ApiBuilder)api);
            }
            for (BodyNode.TypeDef typeDef : node.getReturnDefs()) {
                header = this.visitHeader(typeDef, next);
                header.getValue().accept(output);
                header.getNested().accept((HdesDefSpec.ApiBuilder)api);
            }
            input.build();
            output.build();
        };
        return ImmutableStHeadersSpec.builder().value(consumer).build();
    }

    public StHeaderSpec visitHeader(BodyNode.TypeDef node, HdesTree ctx) {
        if (node instanceof BodyNode.ScalarDef) {
            return this.visitHeader((BodyNode.ScalarDef)node, ctx);
        }
        return this.visitHeader((BodyNode.ObjectDef)node, ctx);
    }

    public StHeaderSpec visitHeader(BodyNode.ScalarDef node, HdesTree ctx) {
        return ImmutableStHeaderSpec.builder().value(immutable -> immutable.method(node).build()).nested(api -> {}).build();
    }

    public StHeaderSpec visitHeader(BodyNode.ObjectDef node, HdesTree ctx) {
        CompilerNode.ServiceUnit unit = (CompilerNode.ServiceUnit)ctx.get().node(CompilerNode.ServiceUnit.class);
        Consumer<HdesDefSpec.ApiBuilder> nested = api -> {
            ImmutableSpec.ImmutableBuilder immutable = node.getContext() == BodyNode.ContextTypeDef.ACCEPTS ? api.inputValue(unit.getAccepts(node).getName()) : api.outputValue(unit.getReturns(node).getName());
            for (BodyNode.TypeDef type : node.getValues()) {
                StHeaderSpec spec = this.visitHeader(type, ctx.next((HdesNode)type));
                spec.getValue().accept(immutable);
                spec.getNested().accept((HdesDefSpec.ApiBuilder)api);
            }
            immutable.build();
        };
        ClassName typeName = node.getContext() == BodyNode.ContextTypeDef.ACCEPTS ? unit.getAccepts(node).getName() : unit.getReturns(node).getName();
        return ImmutableStHeaderSpec.builder().value(arg_0 -> StApiVisitor.lambda$visitHeader$4(node, (TypeName)typeName, arg_0)).nested(nested).build();
    }

    public StSpec visitClassName(InvocationNode invocation, HdesTree ctx) {
        return ImmutableStHeaderSpec.builder().value(immutable -> {}).nested(api -> {}).build();
    }

    public StSpec visitMapping(MappingNode.ObjectMappingDef mapping, HdesTree ctx) {
        return ImmutableStHeaderSpec.builder().value(immutable -> {}).nested(api -> {}).build();
    }

    public StSpec visitCommandInvocation(ServiceNode.CommandInvocation command, HdesTree ctx) {
        return ImmutableStHeaderSpec.builder().value(immutable -> {}).nested(api -> {}).build();
    }

    public StSpec visitPromise(ServiceNode.ServicePromise promise, HdesTree ctx) {
        return null;
    }

    private static /* synthetic */ void lambda$visitHeader$4(BodyNode.ObjectDef node, TypeName typeName, ImmutableSpec.ImmutableBuilder immutable) {
        immutable.method(node, typeName).build();
    }

    @Value.Immutable
    public static interface StHeadersSpec
    extends StSpec {
        public Consumer<HdesDefSpec.ApiBuilder> getValue();
    }

    @Value.Immutable
    public static interface StHeaderSpec
    extends StSpec {
        public Consumer<ImmutableSpec.ImmutableBuilder> getValue();

        public Consumer<HdesDefSpec.ApiBuilder> getNested();
    }
}

