/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.st.visitors;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.InvocationNode;
import io.resys.hdes.ast.api.nodes.MappingNode;
import io.resys.hdes.ast.api.nodes.ServiceNode;
import io.resys.hdes.ast.api.visitors.ServiceBodyVisitor;
import io.resys.hdes.compiler.spi.spec.HdesDefPromiseSpec;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.st.visitors.ImmutableStPromiseHeaderSpec;
import io.resys.hdes.compiler.spi.st.visitors.ImmutableStPromiseHeadersSpec;
import io.resys.hdes.compiler.spi.st.visitors.StSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import java.util.function.Consumer;
import org.immutables.value.Value;

public class StPromiseApiVisitor
implements ServiceBodyVisitor<StSpec, TypeSpec> {
    public TypeSpec visitBody(HdesTree.ServiceTree ctx) {
        CompilerNode.ServiceUnit unit = (CompilerNode.ServiceUnit)ctx.get().node(CompilerNode.ServiceUnit.class);
        CompilerNode.CompilerType compilerType = unit.getType();
        HdesDefPromiseSpec.ApiBuilder api = HdesDefPromiseSpec.api(compilerType);
        this.visitHeaders(ctx.getValue().getHeaders(), (HdesTree)ctx).getValue().accept(api);
        return api.build().build();
    }

    public StPromiseHeadersSpec visitHeaders(BodyNode.Headers node, HdesTree ctx) {
        HdesTree next = ctx.next((HdesNode)node);
        Consumer<HdesDefPromiseSpec.ApiBuilder> consumer = api -> {
            StPromiseHeaderSpec header;
            ImmutableSpec.ImmutableBuilder input = api.inputValue();
            ImmutableSpec.ImmutableBuilder output = api.outputValue();
            for (BodyNode.TypeDef typeDef : node.getAcceptDefs()) {
                header = this.visitHeader(typeDef, next);
                header.getValue().accept(input);
                header.getNested().accept((HdesDefPromiseSpec.ApiBuilder)api);
            }
            for (BodyNode.TypeDef typeDef : node.getReturnDefs()) {
                header = this.visitHeader(typeDef, next);
                header.getValue().accept(output);
                header.getNested().accept((HdesDefPromiseSpec.ApiBuilder)api);
            }
            input.build();
            output.build();
        };
        return ImmutableStPromiseHeadersSpec.builder().value(consumer).build();
    }

    public StPromiseHeaderSpec visitHeader(BodyNode.TypeDef node, HdesTree ctx) {
        if (node instanceof BodyNode.ScalarDef) {
            return this.visitHeader((BodyNode.ScalarDef)node, ctx);
        }
        return this.visitHeader((BodyNode.ObjectDef)node, ctx);
    }

    public StPromiseHeaderSpec visitHeader(BodyNode.ScalarDef node, HdesTree ctx) {
        return ImmutableStPromiseHeaderSpec.builder().value(immutable -> immutable.method(node).build()).nested(api -> {}).build();
    }

    public StPromiseHeaderSpec visitHeader(BodyNode.ObjectDef node, HdesTree ctx) {
        CompilerNode.ServiceUnit unit = (CompilerNode.ServiceUnit)ctx.get().node(CompilerNode.ServiceUnit.class);
        Consumer<HdesDefPromiseSpec.ApiBuilder> nested = api -> {
            ImmutableSpec.ImmutableBuilder immutable = node.getContext() == BodyNode.ContextTypeDef.ACCEPTS ? api.inputValue(unit.getAccepts(node).getName()) : api.outputValue(unit.getReturns(node).getName());
            for (BodyNode.TypeDef type : node.getValues()) {
                StPromiseHeaderSpec spec = this.visitHeader(type, ctx.next((HdesNode)type));
                spec.getValue().accept(immutable);
                spec.getNested().accept((HdesDefPromiseSpec.ApiBuilder)api);
            }
            immutable.build();
        };
        ClassName typeName = node.getContext() == BodyNode.ContextTypeDef.ACCEPTS ? unit.getAccepts(node).getName() : unit.getReturns(node).getName();
        return ImmutableStPromiseHeaderSpec.builder().value(arg_0 -> StPromiseApiVisitor.lambda$visitHeader$4(node, (TypeName)typeName, arg_0)).nested(nested).build();
    }

    public StSpec visitClassName(InvocationNode invocation, HdesTree ctx) {
        return ImmutableStPromiseHeaderSpec.builder().value(immutable -> {}).nested(api -> {}).build();
    }

    public StSpec visitMapping(MappingNode.ObjectMappingDef mapping, HdesTree ctx) {
        return ImmutableStPromiseHeaderSpec.builder().value(immutable -> {}).nested(api -> {}).build();
    }

    public StSpec visitCommandInvocation(ServiceNode.CommandInvocation command, HdesTree ctx) {
        return ImmutableStPromiseHeaderSpec.builder().value(immutable -> {}).nested(api -> {}).build();
    }

    public StSpec visitPromise(ServiceNode.ServicePromise promise, HdesTree ctx) {
        return null;
    }

    private static /* synthetic */ void lambda$visitHeader$4(BodyNode.ObjectDef node, TypeName typeName, ImmutableSpec.ImmutableBuilder immutable) {
        immutable.method(node, typeName).build();
    }

    @Value.Immutable
    public static interface StPromiseHeadersSpec
    extends StSpec {
        public Consumer<HdesDefPromiseSpec.ApiBuilder> getValue();
    }

    @Value.Immutable
    public static interface StPromiseHeaderSpec
    extends StSpec {
        public Consumer<ImmutableSpec.ImmutableBuilder> getValue();

        public Consumer<HdesDefPromiseSpec.ApiBuilder> getNested();
    }
}

