/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.st.visitors;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeSpec;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.HdesTree;
import io.resys.hdes.ast.api.nodes.InvocationNode;
import io.resys.hdes.ast.api.nodes.MappingNode;
import io.resys.hdes.ast.api.nodes.ServiceNode;
import io.resys.hdes.ast.api.visitors.ServiceBodyVisitor;
import io.resys.hdes.compiler.spi.spec.HdesDefPromiseSpec;
import io.resys.hdes.compiler.spi.spec.ImmutableSpec;
import io.resys.hdes.compiler.spi.st.mapping.ServiceMappingFactory;
import io.resys.hdes.compiler.spi.st.visitors.ImmutableStPromiseExecSpec;
import io.resys.hdes.compiler.spi.st.visitors.StSpec;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.executor.api.ImmutablePromiseDataId;
import io.resys.hdes.executor.spi.beans.ImmutableTrace;
import java.util.function.Consumer;
import org.immutables.value.Value;

public class StPromiseImplVisitor
implements ServiceBodyVisitor<StSpec, TypeSpec> {
    public TypeSpec visitBody(HdesTree.ServiceTree ctx) {
        CompilerNode.ServiceUnit unit = (CompilerNode.ServiceUnit)ctx.get().node(CompilerNode.ServiceUnit.class);
        HdesDefPromiseSpec.ImplBuilder impl = HdesDefPromiseSpec.impl(unit.getType());
        ServiceNode.CommandInvocation command = unit.getBody().getCommand();
        ClassName canonicalName = ClassName.bestGuess((String)this.visitInvocation(command.getClassName()));
        CodeBlock mapping = this.createMapping(ctx);
        CodeBlock.Builder onEnter = CodeBlock.builder().addStatement("final var parent = $T.builder().id($S).body($L).build()", new Object[]{ImmutableTrace.class, "input", "input"}).addStatement("final var dataId = new $T().onEnter(input, $L)", new Object[]{canonicalName, mapping}).addStatement("final var returns = $T.builder().dataId(dataId).build()", new Object[]{ImmutablePromiseDataId.class}).addStatement("return $T.builder().id($S).parent(parent).body(returns).promise()", new Object[]{ImmutableTrace.class, ctx.getValue().getId().getValue()});
        CodeBlock.Builder onComplete = CodeBlock.builder().addStatement("final var parent = $T.builder().id($S).body($L).build()", new Object[]{ImmutableTrace.class, "input", "input"}).addStatement("final var invocation = new $T().onComplete(dataId, data, input, $L)", new Object[]{canonicalName, mapping}).addStatement("final var returns = $L", new Object[]{ServiceMappingFactory.returns(ctx)}).addStatement("return $T.builder().id($S).time(System.currentTimeMillis()).parent(parent).body(returns).build()", new Object[]{ImmutableSpec.from(unit.getType().getReturnType().getName()), ctx.getValue().getId().getValue()});
        return impl.onEnter(onEnter.build()).onComplete(onComplete.build()).build().build();
    }

    private CodeBlock createMapping(HdesTree.ServiceTree ctx) {
        ServiceNode.CommandInvocation command = ctx.getValue().getCommand();
        CodeBlock.Builder mapping = CodeBlock.builder();
        this.visitMapping(command.getMapping(), (HdesTree)ctx).getValue().accept(mapping);
        return mapping.build();
    }

    public StPromiseExecSpec visitCommandInvocation(ServiceNode.CommandInvocation command, HdesTree ctx) {
        String canonicalName = this.visitInvocation(command.getClassName());
        CodeBlock.Builder mapping = CodeBlock.builder();
        this.visitMapping(command.getMapping(), ctx).getValue().accept(mapping);
        return ImmutableStPromiseExecSpec.builder().execution(e -> {}).value(b -> b.addStatement("final var invocation = new $T().accept(input, $L)", new Object[]{ClassName.bestGuess((String)canonicalName), mapping.build()})).build();
    }

    public StPromiseExecSpec visitClassName(InvocationNode invocation, HdesTree ctx) {
        return ImmutableStPromiseExecSpec.builder().execution(e -> {}).value(b -> {}).build();
    }

    private String visitInvocation(InvocationNode invocation) {
        if (invocation instanceof InvocationNode.SimpleInvocation) {
            InvocationNode.SimpleInvocation simple = (InvocationNode.SimpleInvocation)invocation;
            return simple.getValue();
        }
        if (invocation instanceof InvocationNode.NestedInvocation) {
            InvocationNode.NestedInvocation nested = (InvocationNode.NestedInvocation)invocation;
            String path = this.visitInvocation(nested.getPath());
            String value = this.visitInvocation(nested.getValue());
            return path + "." + value;
        }
        throw new IllegalArgumentException("Not supported invocation: " + invocation + "!");
    }

    public StPromiseExecSpec visitMapping(MappingNode.ObjectMappingDef mapping, HdesTree ctx) {
        return ImmutableStPromiseExecSpec.builder().execution(e -> {}).value(b -> b.add(ServiceMappingFactory.accepts(mapping, ctx))).build();
    }

    public StPromiseExecSpec visitHeaders(BodyNode.Headers node, HdesTree ctx) {
        return null;
    }

    public StPromiseExecSpec visitHeader(BodyNode.TypeDef node, HdesTree ctx) {
        return null;
    }

    public StPromiseExecSpec visitHeader(BodyNode.ScalarDef node, HdesTree ctx) {
        return null;
    }

    public StPromiseExecSpec visitHeader(BodyNode.ObjectDef node, HdesTree ctx) {
        return null;
    }

    public StSpec visitPromise(ServiceNode.ServicePromise promise, HdesTree ctx) {
        return null;
    }

    @Value.Immutable
    public static interface StPromiseExecSpec
    extends StSpec {
        public Consumer<HdesDefPromiseSpec.ImplBuilder> getExecution();

        public Consumer<CodeBlock.Builder> getValue();
    }
}

