/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.units;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CompilerNode.CompilerEntry", generator="Immutables")
@Immutable
public final class ImmutableCompilerEntry
implements CompilerNode.CompilerEntry {
    private final ClassName name;
    private final TypeName superinterface;

    private ImmutableCompilerEntry(ClassName name, TypeName superinterface) {
        this.name = name;
        this.superinterface = superinterface;
    }

    @Override
    public ClassName getName() {
        return this.name;
    }

    @Override
    public TypeName getSuperinterface() {
        return this.superinterface;
    }

    public final ImmutableCompilerEntry withName(ClassName value) {
        if (this.name == value) {
            return this;
        }
        ClassName newValue = Objects.requireNonNull(value, "name");
        return new ImmutableCompilerEntry(newValue, this.superinterface);
    }

    public final ImmutableCompilerEntry withSuperinterface(TypeName value) {
        if (this.superinterface == value) {
            return this;
        }
        TypeName newValue = Objects.requireNonNull(value, "superinterface");
        return new ImmutableCompilerEntry(this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCompilerEntry && this.equalTo((ImmutableCompilerEntry)another);
    }

    private boolean equalTo(ImmutableCompilerEntry another) {
        return this.name.equals((Object)another.name) && this.superinterface.equals((Object)another.superinterface);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.superinterface.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CompilerEntry").omitNullValues().add("name", (Object)this.name).add("superinterface", (Object)this.superinterface).toString();
    }

    public static ImmutableCompilerEntry copyOf(CompilerNode.CompilerEntry instance) {
        if (instance instanceof ImmutableCompilerEntry) {
            return (ImmutableCompilerEntry)instance;
        }
        return ImmutableCompilerEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CompilerNode.CompilerEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_SUPERINTERFACE = 2L;
        private long initBits = 3L;
        @Nullable
        private ClassName name;
        @Nullable
        private TypeName superinterface;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CompilerNode.CompilerEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.superinterface(instance.getSuperinterface());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(ClassName name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder superinterface(TypeName superinterface) {
            this.superinterface = Objects.requireNonNull(superinterface, "superinterface");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableCompilerEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCompilerEntry(this.name, this.superinterface);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("superinterface");
            }
            return "Cannot build CompilerEntry, some of required attributes are not set " + attributes;
        }
    }
}

