/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.units;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.DecisionTableNode;
import io.resys.hdes.ast.api.nodes.FlowNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.RootNode;
import io.resys.hdes.ast.api.nodes.ServiceNode;
import io.resys.hdes.ast.spi.util.Assertions;
import io.resys.hdes.compiler.api.HdesCompiler;
import io.resys.hdes.compiler.spi.spec.JavaSpecUtil;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.compiler.spi.units.ImmutableCompilerEntry;
import io.resys.hdes.compiler.spi.units.ImmutableCompilerType;
import io.resys.hdes.compiler.spi.units.ImmutableDecisionTableUnit;
import io.resys.hdes.compiler.spi.units.ImmutableFlowUnit;
import io.resys.hdes.compiler.spi.units.ImmutableServiceUnit;
import io.resys.hdes.executor.api.HdesDef;
import io.resys.hdes.executor.api.HdesDefPromise;
import io.resys.hdes.executor.api.Trace;
import io.resys.hdes.executor.api.TraceBody;
import java.util.Optional;

public class ImmutableCompilerNode
implements CompilerNode {
    private final String root;
    private final RootNode ctx;
    private final String fl;
    private final String dt;
    private final String st;

    public ImmutableCompilerNode(RootNode envir, String root, String fl, String dt, String st) {
        this.ctx = envir;
        this.root = root;
        this.fl = root + "." + fl;
        this.dt = root + "." + dt;
        this.st = root + "." + st;
    }

    public HdesNode.Token getToken() {
        return this.ctx.getToken();
    }

    @Override
    public CompilerNode.FlowUnit fl(FlowNode.FlowBody body) {
        CompilerNode.CompilerType compilerType = this.createType(this.fl, (BodyNode)body);
        return new ImmutableFlowUnit(this, compilerType, body);
    }

    @Override
    public CompilerNode.ServiceUnit st(ServiceNode.ServiceBody body) {
        CompilerNode.CompilerType compilerType = this.createType(this.st, (BodyNode)body);
        return new ImmutableServiceUnit(this, compilerType, body);
    }

    @Override
    public ImmutableDecisionTableUnit dt(DecisionTableNode.DecisionTableBody body) {
        CompilerNode.CompilerType compilerType = this.createType(this.dt, (BodyNode)body);
        return new ImmutableDecisionTableUnit(this, compilerType, body);
    }

    public CompilerNode.CompilerType createType(String srcPkg, BodyNode body) {
        Assertions.notNull((Object)srcPkg, () -> "pkg can't be null!");
        Assertions.notNull((Object)body, () -> "body can't be null!");
        String pkg = this.pkg(srcPkg, body);
        ClassName api = ClassName.get((String)pkg, (String)JavaSpecUtil.capitalize(body.getId().getValue()), (String[])new String[0]);
        ClassName impl = ClassName.get((String)pkg, (String)(body.getId().getValue() + "Gen"), (String[])new String[0]);
        ClassName inputValue = ClassName.get((String)api.canonicalName(), (String)(api.simpleName() + "Accepts"), (String[])new String[0]);
        ClassName outputValue = ClassName.get((String)api.canonicalName(), (String)(api.simpleName() + "Returns"), (String[])new String[0]);
        ClassName returnType = ClassName.get((String)api.canonicalName(), (String)(api.simpleName() + "Trace"), (String[])new String[0]);
        return ImmutableCompilerType.builder().pkg(pkg).sourceType(this.sourceType(body)).api(ImmutableCompilerEntry.builder().superinterface((TypeName)this.createSuperinterface(body, inputValue, returnType)).name(api).build()).impl(ImmutableCompilerEntry.builder().superinterface((TypeName)api).name(impl).build()).accepts(ImmutableCompilerEntry.builder().superinterface((TypeName)ClassName.get(TraceBody.Accepts.class)).name(inputValue).build()).returns(ImmutableCompilerEntry.builder().superinterface((TypeName)ClassName.get(TraceBody.Returns.class)).name(outputValue).build()).returnType(ImmutableCompilerEntry.builder().superinterface((TypeName)ClassName.get(Trace.TraceEnd.class)).name(returnType).build()).build();
    }

    private ParameterizedTypeName createSuperinterface(BodyNode node, ClassName inputValue, ClassName returnType) {
        ServiceNode.ServiceBody service;
        if (node instanceof ServiceNode.ServiceBody && (service = (ServiceNode.ServiceBody)node).getCommand().getPromise().isPresent()) {
            return ParameterizedTypeName.get((ClassName)ClassName.get(HdesDefPromise.class), (TypeName[])new TypeName[]{inputValue, returnType});
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get(HdesDef.class), (TypeName[])new TypeName[]{inputValue, returnType});
    }

    private HdesCompiler.ResourceType sourceType(BodyNode node) {
        if (node instanceof FlowNode.FlowBody) {
            return HdesCompiler.ResourceType.FL;
        }
        if (node instanceof DecisionTableNode.DecisionTableBody) {
            return HdesCompiler.ResourceType.DT;
        }
        if (node instanceof ServiceNode.ServiceBody) {
            return HdesCompiler.ResourceType.ST;
        }
        throw new IllegalArgumentException("sourceType not implemented for: " + node + "!");
    }

    private String pkg(String srcPkg, BodyNode body) {
        if (body instanceof FlowNode.FlowBody) {
            FlowNode.FlowBody node = (FlowNode.FlowBody)body;
            return srcPkg + "." + node.getId().getValue().toLowerCase();
        }
        if (body instanceof DecisionTableNode.DecisionTableBody) {
            return srcPkg;
        }
        if (body instanceof ServiceNode.ServiceBody) {
            return srcPkg;
        }
        throw new IllegalArgumentException("Pkg not implemented for: " + body + "!");
    }

    public static Config config() {
        return new Config();
    }

    public static class Config {
        private RootNode envir;
        private String root;
        private String flows;
        private String decisionTables;
        private String serviceTasks;

        public Config ast(RootNode envir) {
            this.envir = envir;
            return this;
        }

        public Config root(String root) {
            this.root = root;
            return this;
        }

        public Config flows(String flows) {
            this.flows = flows;
            return this;
        }

        public Config decisionTables(String decisionTables) {
            this.decisionTables = decisionTables;
            return this;
        }

        public Config serviceTasks(String serviceTasks) {
            this.serviceTasks = serviceTasks;
            return this;
        }

        public ImmutableCompilerNode build() {
            Assertions.notNull((Object)this.envir, () -> "ast can't be null!");
            return new ImmutableCompilerNode(this.envir, Optional.ofNullable(this.root).orElse("io.resys.hdes.compiler"), Optional.ofNullable(this.flows).orElse("fl"), Optional.ofNullable(this.decisionTables).orElse("dt"), Optional.ofNullable(this.serviceTasks).orElse("st"));
        }
    }
}

