/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.units;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.compiler.api.HdesCompiler;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CompilerNode.CompilerType", generator="Immutables")
@Immutable
public final class ImmutableCompilerType
implements CompilerNode.CompilerType {
    private final String pkg;
    private final CompilerNode.CompilerEntry api;
    private final CompilerNode.CompilerEntry impl;
    private final CompilerNode.CompilerEntry accepts;
    private final CompilerNode.CompilerEntry returns;
    private final CompilerNode.CompilerEntry returnType;
    private final HdesCompiler.ResourceType sourceType;

    private ImmutableCompilerType(String pkg, CompilerNode.CompilerEntry api, CompilerNode.CompilerEntry impl, CompilerNode.CompilerEntry accepts, CompilerNode.CompilerEntry returns, CompilerNode.CompilerEntry returnType, HdesCompiler.ResourceType sourceType) {
        this.pkg = pkg;
        this.api = api;
        this.impl = impl;
        this.accepts = accepts;
        this.returns = returns;
        this.returnType = returnType;
        this.sourceType = sourceType;
    }

    @Override
    public String getPkg() {
        return this.pkg;
    }

    @Override
    public CompilerNode.CompilerEntry getApi() {
        return this.api;
    }

    @Override
    public CompilerNode.CompilerEntry getImpl() {
        return this.impl;
    }

    @Override
    public CompilerNode.CompilerEntry getAccepts() {
        return this.accepts;
    }

    @Override
    public CompilerNode.CompilerEntry getReturns() {
        return this.returns;
    }

    @Override
    public CompilerNode.CompilerEntry getReturnType() {
        return this.returnType;
    }

    @Override
    public HdesCompiler.ResourceType getSourceType() {
        return this.sourceType;
    }

    public final ImmutableCompilerType withPkg(String value) {
        String newValue = Objects.requireNonNull(value, "pkg");
        if (this.pkg.equals(newValue)) {
            return this;
        }
        return new ImmutableCompilerType(newValue, this.api, this.impl, this.accepts, this.returns, this.returnType, this.sourceType);
    }

    public final ImmutableCompilerType withApi(CompilerNode.CompilerEntry value) {
        if (this.api == value) {
            return this;
        }
        CompilerNode.CompilerEntry newValue = Objects.requireNonNull(value, "api");
        return new ImmutableCompilerType(this.pkg, newValue, this.impl, this.accepts, this.returns, this.returnType, this.sourceType);
    }

    public final ImmutableCompilerType withImpl(CompilerNode.CompilerEntry value) {
        if (this.impl == value) {
            return this;
        }
        CompilerNode.CompilerEntry newValue = Objects.requireNonNull(value, "impl");
        return new ImmutableCompilerType(this.pkg, this.api, newValue, this.accepts, this.returns, this.returnType, this.sourceType);
    }

    public final ImmutableCompilerType withAccepts(CompilerNode.CompilerEntry value) {
        if (this.accepts == value) {
            return this;
        }
        CompilerNode.CompilerEntry newValue = Objects.requireNonNull(value, "accepts");
        return new ImmutableCompilerType(this.pkg, this.api, this.impl, newValue, this.returns, this.returnType, this.sourceType);
    }

    public final ImmutableCompilerType withReturns(CompilerNode.CompilerEntry value) {
        if (this.returns == value) {
            return this;
        }
        CompilerNode.CompilerEntry newValue = Objects.requireNonNull(value, "returns");
        return new ImmutableCompilerType(this.pkg, this.api, this.impl, this.accepts, newValue, this.returnType, this.sourceType);
    }

    public final ImmutableCompilerType withReturnType(CompilerNode.CompilerEntry value) {
        if (this.returnType == value) {
            return this;
        }
        CompilerNode.CompilerEntry newValue = Objects.requireNonNull(value, "returnType");
        return new ImmutableCompilerType(this.pkg, this.api, this.impl, this.accepts, this.returns, newValue, this.sourceType);
    }

    public final ImmutableCompilerType withSourceType(HdesCompiler.ResourceType value) {
        if (this.sourceType == value) {
            return this;
        }
        HdesCompiler.ResourceType newValue = Objects.requireNonNull(value, "sourceType");
        if (this.sourceType.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableCompilerType(this.pkg, this.api, this.impl, this.accepts, this.returns, this.returnType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCompilerType && this.equalTo((ImmutableCompilerType)another);
    }

    private boolean equalTo(ImmutableCompilerType another) {
        return this.pkg.equals(another.pkg) && this.api.equals(another.api) && this.impl.equals(another.impl) && this.accepts.equals(another.accepts) && this.returns.equals(another.returns) && this.returnType.equals(another.returnType) && this.sourceType.equals((Object)another.sourceType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.pkg.hashCode();
        h += (h << 5) + this.api.hashCode();
        h += (h << 5) + this.impl.hashCode();
        h += (h << 5) + this.accepts.hashCode();
        h += (h << 5) + this.returns.hashCode();
        h += (h << 5) + this.returnType.hashCode();
        h += (h << 5) + this.sourceType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CompilerType").omitNullValues().add("pkg", (Object)this.pkg).add("api", (Object)this.api).add("impl", (Object)this.impl).add("accepts", (Object)this.accepts).add("returns", (Object)this.returns).add("returnType", (Object)this.returnType).add("sourceType", (Object)this.sourceType).toString();
    }

    public static ImmutableCompilerType copyOf(CompilerNode.CompilerType instance) {
        if (instance instanceof ImmutableCompilerType) {
            return (ImmutableCompilerType)instance;
        }
        return ImmutableCompilerType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CompilerNode.CompilerType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PKG = 1L;
        private static final long INIT_BIT_API = 2L;
        private static final long INIT_BIT_IMPL = 4L;
        private static final long INIT_BIT_ACCEPTS = 8L;
        private static final long INIT_BIT_RETURNS = 16L;
        private static final long INIT_BIT_RETURN_TYPE = 32L;
        private static final long INIT_BIT_SOURCE_TYPE = 64L;
        private long initBits = 127L;
        @Nullable
        private String pkg;
        @Nullable
        private CompilerNode.CompilerEntry api;
        @Nullable
        private CompilerNode.CompilerEntry impl;
        @Nullable
        private CompilerNode.CompilerEntry accepts;
        @Nullable
        private CompilerNode.CompilerEntry returns;
        @Nullable
        private CompilerNode.CompilerEntry returnType;
        @Nullable
        private HdesCompiler.ResourceType sourceType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CompilerNode.CompilerType instance) {
            Objects.requireNonNull(instance, "instance");
            this.pkg(instance.getPkg());
            this.api(instance.getApi());
            this.impl(instance.getImpl());
            this.accepts(instance.getAccepts());
            this.returns(instance.getReturns());
            this.returnType(instance.getReturnType());
            this.sourceType(instance.getSourceType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pkg(String pkg) {
            this.pkg = Objects.requireNonNull(pkg, "pkg");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder api(CompilerNode.CompilerEntry api) {
            this.api = Objects.requireNonNull(api, "api");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder impl(CompilerNode.CompilerEntry impl) {
            this.impl = Objects.requireNonNull(impl, "impl");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accepts(CompilerNode.CompilerEntry accepts) {
            this.accepts = Objects.requireNonNull(accepts, "accepts");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder returns(CompilerNode.CompilerEntry returns) {
            this.returns = Objects.requireNonNull(returns, "returns");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder returnType(CompilerNode.CompilerEntry returnType) {
            this.returnType = Objects.requireNonNull(returnType, "returnType");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceType(HdesCompiler.ResourceType sourceType) {
            this.sourceType = Objects.requireNonNull(sourceType, "sourceType");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public ImmutableCompilerType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCompilerType(this.pkg, this.api, this.impl, this.accepts, this.returns, this.returnType, this.sourceType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pkg");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("api");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("impl");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("accepts");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("returns");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("returnType");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("sourceType");
            }
            return "Cannot build CompilerType, some of required attributes are not set " + attributes;
        }
    }
}

