/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.units;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import io.resys.hdes.ast.api.nodes.BodyNode;
import io.resys.hdes.ast.api.nodes.HdesNode;
import io.resys.hdes.ast.api.nodes.ServiceNode;
import io.resys.hdes.compiler.spi.spec.JavaSpecUtil;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import io.resys.hdes.compiler.spi.units.ImmutableCompilerEntry;
import io.resys.hdes.compiler.spi.units.ImmutableCompilerNode;

public class ImmutableServiceUnit
implements CompilerNode.ServiceUnit {
    private final ImmutableCompilerNode parent;
    private final CompilerNode.CompilerType compilerType;
    private final ServiceNode.ServiceBody ctx;

    public ImmutableServiceUnit(ImmutableCompilerNode parent, CompilerNode.CompilerType compilerType, ServiceNode.ServiceBody ctx) {
        this.parent = parent;
        this.compilerType = compilerType;
        this.ctx = ctx;
    }

    @Override
    public CompilerNode.CompilerEntry getAccepts(BodyNode.ObjectDef object) {
        ClassName name = ClassName.get((String)this.compilerType.getApi().getName().canonicalName(), (String)("Accepts" + JavaSpecUtil.capitalize(object.getName())), (String[])new String[0]);
        TypeName superinterface = this.compilerType.getReturns().getSuperinterface();
        return ImmutableCompilerEntry.builder().name(name).superinterface(superinterface).build();
    }

    @Override
    public CompilerNode.CompilerEntry getReturns(BodyNode.ObjectDef object) {
        ClassName name = ClassName.get((String)this.compilerType.getApi().getName().canonicalName(), (String)("Returns" + JavaSpecUtil.capitalize(object.getName())), (String[])new String[0]);
        TypeName superinterface = this.compilerType.getReturns().getSuperinterface();
        return ImmutableCompilerEntry.builder().name(name).superinterface(superinterface).build();
    }

    @Override
    public CompilerNode.CompilerType getType() {
        return this.compilerType;
    }

    public HdesNode.Token getToken() {
        return this.ctx.getToken();
    }

    @Override
    public ServiceNode.ServiceBody getBody() {
        return this.ctx;
    }
}

