/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.compiler.spi.units;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.ClassName;
import io.resys.hdes.compiler.spi.units.CompilerNode;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CompilerNode.TaskRefNaming", generator="Immutables")
@Immutable
public final class ImmutableTaskRefNaming
implements CompilerNode.TaskRefNaming {
    private final Boolean array;
    private final CompilerNode.CompilerType type;
    private final ClassName meta;

    private ImmutableTaskRefNaming(Boolean array, CompilerNode.CompilerType type, ClassName meta) {
        this.array = array;
        this.type = type;
        this.meta = meta;
    }

    @Override
    public Boolean getArray() {
        return this.array;
    }

    @Override
    public CompilerNode.CompilerType getType() {
        return this.type;
    }

    @Override
    public ClassName getMeta() {
        return this.meta;
    }

    public final ImmutableTaskRefNaming withArray(Boolean value) {
        Boolean newValue = Objects.requireNonNull(value, "array");
        if (this.array.equals(newValue)) {
            return this;
        }
        return new ImmutableTaskRefNaming(newValue, this.type, this.meta);
    }

    public final ImmutableTaskRefNaming withType(CompilerNode.CompilerType value) {
        if (this.type == value) {
            return this;
        }
        CompilerNode.CompilerType newValue = Objects.requireNonNull(value, "type");
        return new ImmutableTaskRefNaming(this.array, newValue, this.meta);
    }

    public final ImmutableTaskRefNaming withMeta(ClassName value) {
        if (this.meta == value) {
            return this;
        }
        ClassName newValue = Objects.requireNonNull(value, "meta");
        return new ImmutableTaskRefNaming(this.array, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTaskRefNaming && this.equalTo((ImmutableTaskRefNaming)another);
    }

    private boolean equalTo(ImmutableTaskRefNaming another) {
        return this.array.equals(another.array) && this.type.equals(another.type) && this.meta.equals((Object)another.meta);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.array.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.meta.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TaskRefNaming").omitNullValues().add("array", (Object)this.array).add("type", (Object)this.type).add("meta", (Object)this.meta).toString();
    }

    public static ImmutableTaskRefNaming copyOf(CompilerNode.TaskRefNaming instance) {
        if (instance instanceof ImmutableTaskRefNaming) {
            return (ImmutableTaskRefNaming)instance;
        }
        return ImmutableTaskRefNaming.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CompilerNode.TaskRefNaming", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ARRAY = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_META = 4L;
        private long initBits = 7L;
        @Nullable
        private Boolean array;
        @Nullable
        private CompilerNode.CompilerType type;
        @Nullable
        private ClassName meta;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CompilerNode.TaskRefNaming instance) {
            Objects.requireNonNull(instance, "instance");
            this.array(instance.getArray());
            this.type(instance.getType());
            this.meta(instance.getMeta());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder array(Boolean array) {
            this.array = Objects.requireNonNull(array, "array");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(CompilerNode.CompilerType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder meta(ClassName meta) {
            this.meta = Objects.requireNonNull(meta, "meta");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableTaskRefNaming build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTaskRefNaming(this.array, this.type, this.meta);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("array");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("meta");
            }
            return "Cannot build TaskRefNaming, some of required attributes are not set " + attributes;
        }
    }
}

