/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.runtime.spi.tools;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public abstract class HdesJavaFileObject
extends SimpleJavaFileObject {
    private String className;

    public HdesJavaFileObject(String className, URI uri, JavaFileObject.Kind kind) {
        super(uri, kind);
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public abstract byte[] getBytes();

    public static HdesJavaFileObject create(String className, final CharSequence content) {
        URI uri = URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension);
        JavaFileObject.Kind kind = JavaFileObject.Kind.SOURCE;
        return new HdesJavaFileObject(className, uri, kind){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                return content;
            }

            @Override
            public byte[] getBytes() {
                return content.toString().getBytes(StandardCharsets.UTF_8);
            }
        };
    }

    public static HdesJavaFileObject create(String className, JavaFileObject.Kind kind) {
        URI uri = URI.create("string:///" + className.replace('.', '/') + kind.extension);
        return new HdesJavaFileObject(className, uri, kind){
            private ByteArrayOutputStream content = new ByteArrayOutputStream();
            private byte[] bytes;

            @Override
            public OutputStream openOutputStream() {
                return this.content;
            }

            @Override
            public byte[] getBytes() {
                if (this.bytes == null) {
                    this.bytes = this.content.toByteArray();
                    this.content = null;
                }
                return this.bytes;
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                return new String(this.content.toByteArray(), StandardCharsets.UTF_8);
            }
        };
    }
}

