/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.runtime.spi.tools;

import io.resys.hdes.compiler.api.HdesCompiler;
import io.resys.hdes.executor.api.HdesRunnable;
import io.resys.hdes.runtime.api.HdesRuntime;
import io.resys.hdes.runtime.api.ImmutableRuntimeTask;
import io.resys.hdes.runtime.spi.tools.HdesJavaFileManager;
import io.resys.hdes.runtime.spi.tools.HdesJavaFileObject;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableRuntimeEnvir
implements HdesRuntime.RuntimeEnvir {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableRuntimeEnvir.class);
    private final HdesClassLoader classLoader;
    private final Map<String, HdesCompiler.ResourceName> executables;
    private final Map<String, HdesCompiler.Resource> values;
    private final List<Diagnostic<?>> diagnostics;

    @Override
    public List<Diagnostic<?>> getDiagnostics() {
        return this.diagnostics;
    }

    public ImmutableRuntimeEnvir(HdesClassLoader classLoader, Map<String, HdesCompiler.ResourceName> executables, Map<String, HdesCompiler.Resource> values, List<Diagnostic<?>> diagnostics) {
        this.classLoader = classLoader;
        this.executables = executables;
        this.values = values;
        this.diagnostics = diagnostics;
    }

    @Override
    public HdesRuntime.RuntimeTask get(String name) throws ClassNotFoundException {
        Object lookup = name;
        if (this.executables.containsKey(name)) {
            HdesCompiler.ResourceName typeName = this.executables.get(name);
            lookup = typeName.getPkg() + "." + typeName.getName();
        }
        Class<?> clazz = this.classLoader.findClass((String)lookup);
        try {
            HdesCompiler.Resource resource = this.values.get(name);
            Class<?> accepts = this.classLoader.findClass(resource.getAccepts().getPkg() + "$" + resource.getAccepts().getName());
            Class<?> ends = this.classLoader.findClass(resource.getAccepts().getPkg() + "$" + resource.getEnds().getName());
            Class<?> returns = this.classLoader.findClass(resource.getAccepts().getPkg() + "$" + resource.getReturns().getName());
            HdesRunnable executable = (HdesRunnable)clazz.getConstructors()[0].newInstance(new Object[0]);
            return ImmutableRuntimeTask.builder().name(name).accepts(accepts).returns(returns).ends(ends).value(executable).build();
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static ImmutableRuntimeEnvir from(HdesJavaFileManager fileManager, List<Diagnostic<?>> diagnostics, Map<String, HdesCompiler.ResourceName> executables, Map<String, HdesCompiler.Resource> values) {
        List errors = diagnostics.stream().filter(d -> d.getKind() == Diagnostic.Kind.ERROR).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            LOGGER.error(errors.toString());
            System.err.println(errors);
        }
        Map<String, HdesJavaFileObject> cache = fileManager.getCache();
        HdesClassLoader classLoader = new HdesClassLoader(cache);
        return new ImmutableRuntimeEnvir(classLoader, executables, values, diagnostics);
    }

    private static class HdesClassLoader
    extends ClassLoader {
        private final Map<String, HdesJavaFileObject> cache;

        public HdesClassLoader(Map<String, HdesJavaFileObject> cache) {
            super(HdesClassLoader.class.getClassLoader());
            this.cache = cache;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                HdesJavaFileObject javaFileObject = this.cache.get(name);
                if (javaFileObject == null) {
                    return super.findClass(name);
                }
                byte[] bytes = javaFileObject.getBytes();
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            catch (ClassNotFoundException e) {
                StringBuilder msg = new StringBuilder().append("Failed to find class with name: ").append(name).append("!").append(System.lineSeparator()).append("Known generated class names are: ");
                for (String gen : this.cache.keySet()) {
                    msg.append("  - ").append(gen).append(System.lineSeparator());
                }
                msg.append("Original exception message: ").append(e.getMessage());
                throw new ClassNotFoundException(msg.toString(), e);
            }
        }
    }
}

