package io.resys.hdes.runtime.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.hdes.executor.api.HdesRunnable;
import io.resys.hdes.executor.api.Trace;
import io.resys.hdes.executor.api.TraceBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link HdesRuntime.RuntimeTask}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRuntimeTask.builder()}.
 */
@Generated(from = "HdesRuntime.RuntimeTask", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRuntimeTask implements HdesRuntime.RuntimeTask {
  private final String name;
  private final HdesRunnable value;
  private final Class<? extends TraceBody.Accepts> accepts;
  private final Class<? extends TraceBody.Returns> returns;
  private final Class<? extends Trace.TraceEnd> ends;

  private ImmutableRuntimeTask(
      String name,
      HdesRunnable value,
      Class<? extends TraceBody.Accepts> accepts,
      Class<? extends TraceBody.Returns> returns,
      Class<? extends Trace.TraceEnd> ends) {
    this.name = name;
    this.value = value;
    this.accepts = accepts;
    this.returns = returns;
    this.ends = ends;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public HdesRunnable getValue() {
    return value;
  }

  /**
   * @return The value of the {@code accepts} attribute
   */
  @Override
  public Class<? extends TraceBody.Accepts> getAccepts() {
    return accepts;
  }

  /**
   * @return The value of the {@code returns} attribute
   */
  @Override
  public Class<? extends TraceBody.Returns> getReturns() {
    return returns;
  }

  /**
   * @return The value of the {@code ends} attribute
   */
  @Override
  public Class<? extends Trace.TraceEnd> getEnds() {
    return ends;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HdesRuntime.RuntimeTask#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeTask withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableRuntimeTask(newValue, this.value, this.accepts, this.returns, this.ends);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HdesRuntime.RuntimeTask#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeTask withValue(HdesRunnable value) {
    if (this.value == value) return this;
    HdesRunnable newValue = Objects.requireNonNull(value, "value");
    return new ImmutableRuntimeTask(this.name, newValue, this.accepts, this.returns, this.ends);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HdesRuntime.RuntimeTask#getAccepts() accepts} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for accepts
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeTask withAccepts(Class<? extends TraceBody.Accepts> value) {
    if (this.accepts == value) return this;
    Class<? extends TraceBody.Accepts> newValue = Objects.requireNonNull(value, "accepts");
    return new ImmutableRuntimeTask(this.name, this.value, newValue, this.returns, this.ends);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HdesRuntime.RuntimeTask#getReturns() returns} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for returns
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeTask withReturns(Class<? extends TraceBody.Returns> value) {
    if (this.returns == value) return this;
    Class<? extends TraceBody.Returns> newValue = Objects.requireNonNull(value, "returns");
    return new ImmutableRuntimeTask(this.name, this.value, this.accepts, newValue, this.ends);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HdesRuntime.RuntimeTask#getEnds() ends} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ends
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRuntimeTask withEnds(Class<? extends Trace.TraceEnd> value) {
    if (this.ends == value) return this;
    Class<? extends Trace.TraceEnd> newValue = Objects.requireNonNull(value, "ends");
    return new ImmutableRuntimeTask(this.name, this.value, this.accepts, this.returns, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRuntimeTask} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRuntimeTask
        && equalTo((ImmutableRuntimeTask) another);
  }

  private boolean equalTo(ImmutableRuntimeTask another) {
    return name.equals(another.name)
        && value.equals(another.value)
        && accepts.equals(another.accepts)
        && returns.equals(another.returns)
        && ends.equals(another.ends);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code value}, {@code accepts}, {@code returns}, {@code ends}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + value.hashCode();
    h += (h << 5) + accepts.hashCode();
    h += (h << 5) + returns.hashCode();
    h += (h << 5) + ends.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RuntimeTask} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RuntimeTask")
        .omitNullValues()
        .add("name", name)
        .add("value", value)
        .add("accepts", accepts)
        .add("returns", returns)
        .add("ends", ends)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link HdesRuntime.RuntimeTask} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RuntimeTask instance
   */
  public static ImmutableRuntimeTask copyOf(HdesRuntime.RuntimeTask instance) {
    if (instance instanceof ImmutableRuntimeTask) {
      return (ImmutableRuntimeTask) instance;
    }
    return ImmutableRuntimeTask.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRuntimeTask ImmutableRuntimeTask}.
   * <pre>
   * ImmutableRuntimeTask.builder()
   *    .name(String) // required {@link HdesRuntime.RuntimeTask#getName() name}
   *    .value(io.resys.hdes.executor.api.HdesRunnable) // required {@link HdesRuntime.RuntimeTask#getValue() value}
   *    .accepts(Class&amp;lt;? extends io.resys.hdes.executor.api.TraceBody.Accepts&amp;gt;) // required {@link HdesRuntime.RuntimeTask#getAccepts() accepts}
   *    .returns(Class&amp;lt;? extends io.resys.hdes.executor.api.TraceBody.Returns&amp;gt;) // required {@link HdesRuntime.RuntimeTask#getReturns() returns}
   *    .ends(Class&amp;lt;? extends io.resys.hdes.executor.api.Trace.TraceEnd&amp;gt;) // required {@link HdesRuntime.RuntimeTask#getEnds() ends}
   *    .build();
   * </pre>
   * @return A new ImmutableRuntimeTask builder
   */
  public static ImmutableRuntimeTask.Builder builder() {
    return new ImmutableRuntimeTask.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRuntimeTask ImmutableRuntimeTask}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "HdesRuntime.RuntimeTask", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private static final long INIT_BIT_ACCEPTS = 0x4L;
    private static final long INIT_BIT_RETURNS = 0x8L;
    private static final long INIT_BIT_ENDS = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String name;
    private @Nullable HdesRunnable value;
    private @Nullable Class<? extends TraceBody.Accepts> accepts;
    private @Nullable Class<? extends TraceBody.Returns> returns;
    private @Nullable Class<? extends Trace.TraceEnd> ends;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RuntimeTask} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(HdesRuntime.RuntimeTask instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      value(instance.getValue());
      accepts(instance.getAccepts());
      returns(instance.getReturns());
      ends(instance.getEnds());
      return this;
    }

    /**
     * Initializes the value for the {@link HdesRuntime.RuntimeTask#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link HdesRuntime.RuntimeTask#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(HdesRunnable value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link HdesRuntime.RuntimeTask#getAccepts() accepts} attribute.
     * @param accepts The value for accepts 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder accepts(Class<? extends TraceBody.Accepts> accepts) {
      this.accepts = Objects.requireNonNull(accepts, "accepts");
      initBits &= ~INIT_BIT_ACCEPTS;
      return this;
    }

    /**
     * Initializes the value for the {@link HdesRuntime.RuntimeTask#getReturns() returns} attribute.
     * @param returns The value for returns 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder returns(Class<? extends TraceBody.Returns> returns) {
      this.returns = Objects.requireNonNull(returns, "returns");
      initBits &= ~INIT_BIT_RETURNS;
      return this;
    }

    /**
     * Initializes the value for the {@link HdesRuntime.RuntimeTask#getEnds() ends} attribute.
     * @param ends The value for ends 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ends(Class<? extends Trace.TraceEnd> ends) {
      this.ends = Objects.requireNonNull(ends, "ends");
      initBits &= ~INIT_BIT_ENDS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRuntimeTask ImmutableRuntimeTask}.
     * @return An immutable instance of RuntimeTask
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRuntimeTask build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRuntimeTask(name, value, accepts, returns, ends);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_ACCEPTS) != 0) attributes.add("accepts");
      if ((initBits & INIT_BIT_RETURNS) != 0) attributes.add("returns");
      if ((initBits & INIT_BIT_ENDS) != 0) attributes.add("ends");
      return "Cannot build RuntimeTask, some of required attributes are not set " + attributes;
    }
  }
}
