/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.runtime.api;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.resys.hdes.executor.api.HdesRunnable;
import io.resys.hdes.executor.api.Trace;
import io.resys.hdes.executor.api.TraceBody;
import io.resys.hdes.runtime.api.HdesRuntime;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HdesRuntime.RuntimeTask", generator="Immutables")
@Immutable
public final class ImmutableRuntimeTask
implements HdesRuntime.RuntimeTask {
    private final String name;
    private final HdesRunnable value;
    private final Class<? extends TraceBody.Accepts> accepts;
    private final Class<? extends TraceBody.Returns> returns;
    private final Class<? extends Trace.TraceEnd> ends;

    private ImmutableRuntimeTask(String name, HdesRunnable value, Class<? extends TraceBody.Accepts> accepts, Class<? extends TraceBody.Returns> returns, Class<? extends Trace.TraceEnd> ends) {
        this.name = name;
        this.value = value;
        this.accepts = accepts;
        this.returns = returns;
        this.ends = ends;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HdesRunnable getValue() {
        return this.value;
    }

    @Override
    public Class<? extends TraceBody.Accepts> getAccepts() {
        return this.accepts;
    }

    @Override
    public Class<? extends TraceBody.Returns> getReturns() {
        return this.returns;
    }

    @Override
    public Class<? extends Trace.TraceEnd> getEnds() {
        return this.ends;
    }

    public final ImmutableRuntimeTask withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRuntimeTask(newValue, this.value, this.accepts, this.returns, this.ends);
    }

    public final ImmutableRuntimeTask withValue(HdesRunnable value) {
        if (this.value == value) {
            return this;
        }
        HdesRunnable newValue = Objects.requireNonNull(value, "value");
        return new ImmutableRuntimeTask(this.name, newValue, this.accepts, this.returns, this.ends);
    }

    public final ImmutableRuntimeTask withAccepts(Class<? extends TraceBody.Accepts> value) {
        if (this.accepts == value) {
            return this;
        }
        Class<? extends TraceBody.Accepts> newValue = Objects.requireNonNull(value, "accepts");
        return new ImmutableRuntimeTask(this.name, this.value, newValue, this.returns, this.ends);
    }

    public final ImmutableRuntimeTask withReturns(Class<? extends TraceBody.Returns> value) {
        if (this.returns == value) {
            return this;
        }
        Class<? extends TraceBody.Returns> newValue = Objects.requireNonNull(value, "returns");
        return new ImmutableRuntimeTask(this.name, this.value, this.accepts, newValue, this.ends);
    }

    public final ImmutableRuntimeTask withEnds(Class<? extends Trace.TraceEnd> value) {
        if (this.ends == value) {
            return this;
        }
        Class<? extends Trace.TraceEnd> newValue = Objects.requireNonNull(value, "ends");
        return new ImmutableRuntimeTask(this.name, this.value, this.accepts, this.returns, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRuntimeTask && this.equalTo((ImmutableRuntimeTask)another);
    }

    private boolean equalTo(ImmutableRuntimeTask another) {
        return this.name.equals(another.name) && this.value.equals(another.value) && this.accepts.equals(another.accepts) && this.returns.equals(another.returns) && this.ends.equals(another.ends);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.accepts.hashCode();
        h += (h << 5) + this.returns.hashCode();
        h += (h << 5) + this.ends.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RuntimeTask").omitNullValues().add("name", (Object)this.name).add("value", (Object)this.value).add("accepts", this.accepts).add("returns", this.returns).add("ends", this.ends).toString();
    }

    public static ImmutableRuntimeTask copyOf(HdesRuntime.RuntimeTask instance) {
        if (instance instanceof ImmutableRuntimeTask) {
            return (ImmutableRuntimeTask)instance;
        }
        return ImmutableRuntimeTask.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HdesRuntime.RuntimeTask", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private static final long INIT_BIT_ACCEPTS = 4L;
        private static final long INIT_BIT_RETURNS = 8L;
        private static final long INIT_BIT_ENDS = 16L;
        private long initBits = 31L;
        @Nullable
        private String name;
        @Nullable
        private HdesRunnable value;
        @Nullable
        private Class<? extends TraceBody.Accepts> accepts;
        @Nullable
        private Class<? extends TraceBody.Returns> returns;
        @Nullable
        private Class<? extends Trace.TraceEnd> ends;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HdesRuntime.RuntimeTask instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.value(instance.getValue());
            this.accepts(instance.getAccepts());
            this.returns(instance.getReturns());
            this.ends(instance.getEnds());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(HdesRunnable value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder accepts(Class<? extends TraceBody.Accepts> accepts) {
            this.accepts = Objects.requireNonNull(accepts, "accepts");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder returns(Class<? extends TraceBody.Returns> returns) {
            this.returns = Objects.requireNonNull(returns, "returns");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ends(Class<? extends Trace.TraceEnd> ends) {
            this.ends = Objects.requireNonNull(ends, "ends");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableRuntimeTask build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRuntimeTask(this.name, this.value, this.accepts, this.returns, this.ends);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("accepts");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("returns");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("ends");
            }
            return "Cannot build RuntimeTask, some of required attributes are not set " + attributes;
        }
    }
}

