/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.runtime.spi;

import io.resys.hdes.compiler.api.HdesCompiler;
import io.resys.hdes.runtime.api.HdesRuntime;
import io.resys.hdes.runtime.spi.tools.HdesJavaFileManager;
import io.resys.hdes.runtime.spi.tools.HdesJavaFileObject;
import io.resys.hdes.runtime.spi.tools.ImmutableRuntimeEnvir;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.immutables.processor.ProxyProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableHdesRuntime
implements HdesRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableHdesRuntime.class);

    public static HdesRuntime.Builder builder() {
        return new ImmutableEnvirBuilder();
    }

    private static void log(HdesCompiler.ResourceDeclaration type) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder result = new StringBuilder().append(System.lineSeparator()).append("Declaration: '").append(type.getType().getName()).append("'").append(System.lineSeparator());
            int index = 1;
            for (String value : type.getValue().split("\\r?\\n")) {
                result.append(index++).append(":   ").append(value).append(System.lineSeparator());
            }
            LOGGER.debug(result.toString());
        }
    }

    public static class ImmutableEnvirBuilder
    implements HdesRuntime.Builder {
        private final List<HdesCompiler.Resource> resources = new ArrayList<HdesCompiler.Resource>();

        @Override
        public HdesRuntime.RuntimeEnvir build() {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            HdesJavaFileManager fileManager = HdesJavaFileManager.create(compiler);
            DiagnosticCollector diagnosticListener = new DiagnosticCollector();
            List<String> options = Arrays.asList(new String[0]);
            StringWriter out = new StringWriter();
            ArrayList<String> annotatedClasses = new ArrayList<String>();
            ArrayList<HdesJavaFileObject> files = new ArrayList<HdesJavaFileObject>();
            HashMap<String, HdesCompiler.ResourceName> executables = new HashMap<String, HdesCompiler.ResourceName>();
            HashMap<String, HdesCompiler.Resource> values = new HashMap<String, HdesCompiler.Resource>();
            for (HdesCompiler.Resource resource : this.resources) {
                values.put(resource.getName(), resource);
                for (HdesCompiler.ResourceName typeName : resource.getTypes()) {
                    annotatedClasses.add(typeName.getPkg() + "." + typeName.getName());
                }
                for (HdesCompiler.ResourceDeclaration typeDeclaration : resource.getDeclarations()) {
                    ImmutableHdesRuntime.log(typeDeclaration);
                    files.add(HdesJavaFileObject.create(typeDeclaration.getType().getName(), typeDeclaration.getValue()));
                    if (!typeDeclaration.isExecutable()) continue;
                    executables.put(resource.getName(), typeDeclaration.getType());
                }
            }
            JavaCompiler.CompilationTask task = compiler.getTask(out, fileManager, diagnosticListener, options, annotatedClasses, files);
            ProxyProcessor immutables = new ProxyProcessor();
            task.setProcessors(Arrays.asList(immutables));
            task.call();
            List<Diagnostic<?>> diagnostics = diagnosticListener.getDiagnostics();
            return ImmutableRuntimeEnvir.from(fileManager, diagnostics, executables, Collections.unmodifiableMap(values));
        }

        @Override
        public HdesRuntime.Builder from(List<HdesCompiler.Resource> resources) {
            if (resources != null) {
                this.resources.addAll(resources);
            }
            return this;
        }
    }
}

