/*
 * Decompiled with CFR 0.152.
 */
package io.resys.hdes.quarkus.composer.pg;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.resys.hdes.client.api.HdesClient;
import io.resys.hdes.client.api.HdesComposer;
import io.resys.hdes.client.api.HdesStore;
import io.resys.hdes.client.api.ImmutableHdesCreds;
import io.resys.hdes.client.spi.HdesClientImpl;
import io.resys.hdes.client.spi.HdesComposerImpl;
import io.resys.hdes.client.spi.ThenaStore;
import io.resys.hdes.client.spi.config.HdesClientConfig;
import io.resys.hdes.client.spi.flow.validators.IdValidator;
import io.resys.hdes.client.spi.util.HdesAssert;
import io.resys.hdes.client.spi.web.HdesWebConfig;
import io.resys.hdes.client.spi.web.HdesWebContext;
import io.resys.hdes.quarkus.composer.pg.ComposerRuntimeConfig;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.pgclient.PgPool;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.CDI;
import javax.inject.Singleton;

@ApplicationScoped
public class ComposerBeansProducer {
    private ComposerRuntimeConfig runtimeConfig;
    private HdesWebConfig hdesWebConfig;

    public ComposerBeansProducer setRuntimeConfig(ComposerRuntimeConfig runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
        return this;
    }

    @Produces
    @ApplicationScoped
    public RegisterGuava registerGuava() {
        return new RegisterGuava();
    }

    @Produces
    @ApplicationScoped
    public HdesWebContext hdesWebContext(Vertx vertx, ObjectMapper objectMapper, PgPool pgPool) {
        HdesAssert.notNull((Object)this.hdesWebConfig, () -> "hdesWebConfig must be defined!");
        HdesClientConfig.ServiceInit init = new HdesClientConfig.ServiceInit(){

            public <T> T get(Class<T> type) {
                try {
                    return (T)type.getDeclaredConstructors()[0].newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        };
        Instance cdiCreds = CDI.current().select(HdesStore.HdesCredsSupplier.class, new Annotation[0]);
        HdesStore.HdesCredsSupplier creds = cdiCreds.isUnsatisfied() ? () -> ImmutableHdesCreds.builder().user("assetManager").email("assetManager@resys.io").build() : (HdesStore.HdesCredsSupplier)cdiCreds.get();
        ThenaStore store = ThenaStore.builder().objectMapper(objectMapper).pgPool(pgPool).repoName(this.runtimeConfig.repo.repoName).headName(this.runtimeConfig.repo.headName).authorProvider(() -> ((HdesStore.HdesCreds)creds.get()).getUser()).objectMapper(objectMapper).build();
        HdesClientImpl client = HdesClientImpl.builder().store((HdesStore)store).objectMapper(objectMapper).serviceInit(init).dependencyInjectionContext(new HdesClientConfig.DependencyInjectionContext(){

            public <T> T get(Class<T> type) {
                return (T)CDI.current().select(type, new Annotation[0]).get();
            }
        }).flowVisitors(new HdesClientConfig.AstFlowNodeVisitor[]{new IdValidator()}).build();
        HdesComposerImpl composer = new HdesComposerImpl((HdesClient)client);
        return new HdesWebContext((HdesComposer)composer, (HdesClient)client, this.hdesWebConfig);
    }

    public ComposerBeansProducer setHdesWebConfig(HdesWebConfig hdesWebConfig) {
        this.hdesWebConfig = hdesWebConfig;
        return this;
    }

    public static String cleanPath(String value) {
        String start = value.startsWith("/") ? value.substring(1) : value;
        return start.endsWith("/") ? value.substring(0, start.length() - 2) : start;
    }

    @Singleton
    public static class RegisterGuava
    implements ObjectMapperCustomizer {
        public void customize(ObjectMapper objectMapper) {
            objectMapper.registerModule((Module)new GuavaModule());
        }
    }
}

