/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.rpc.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.rsocket.rpc.metrics.MetricsFuseableConditionalSubscriber;
import io.rsocket.rpc.metrics.MetricsFuseableSubscriber;
import io.rsocket.rpc.metrics.MetricsSubscriber;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.Fuseable;
import reactor.core.publisher.Operators;

public class Metrics {
    Metrics() {
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> timed(MeterRegistry registry, String name, String ... keyValues) {
        return Metrics.timed(registry, name, (Iterable<Tag>)Tags.of((String[])keyValues));
    }

    public static <T> Function<? super Publisher<T>, ? extends Publisher<T>> timed(MeterRegistry registry, String name, Iterable<Tag> tags) {
        Counter next = Counter.builder((String)(name + ".request")).tags(new String[]{"status", "next"}).tags(tags).register(registry);
        Counter complete = Counter.builder((String)(name + ".request")).tags(new String[]{"status", "complete"}).tags(tags).register(registry);
        Counter error = Counter.builder((String)(name + ".request")).tags(new String[]{"status", "error"}).tags(tags).register(registry);
        Counter cancelled = Counter.builder((String)(name + ".request")).tags(new String[]{"status", "cancelled"}).tags(tags).register(registry);
        Timer timer = Timer.builder((String)(name + ".latency")).publishPercentiles(new double[]{0.5, 0.9, 0.95, 0.99}).tags(tags).register(registry);
        return Operators.lift((scannable, subscriber) -> {
            if (scannable instanceof Fuseable) {
                if (subscriber instanceof Fuseable.ConditionalSubscriber) {
                    return new MetricsFuseableConditionalSubscriber((Fuseable.ConditionalSubscriber)subscriber, next, complete, error, cancelled, timer);
                }
                return new MetricsFuseableSubscriber(subscriber, next, complete, error, cancelled, timer);
            }
            if (subscriber instanceof Fuseable.ConditionalSubscriber) {
                return new MetricsFuseableConditionalSubscriber((Fuseable.ConditionalSubscriber)subscriber, next, complete, error, cancelled, timer);
            }
            return new MetricsSubscriber(subscriber, next, complete, error, cancelled, timer);
        });
    }
}

