/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.rpc.metrics;

import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.netty.buffer.Unpooled;
import io.rsocket.rpc.metrics.om.Meter;
import io.rsocket.rpc.metrics.om.MeterId;
import io.rsocket.rpc.metrics.om.MeterMeasurement;
import io.rsocket.rpc.metrics.om.MeterStatistic;
import io.rsocket.rpc.metrics.om.MeterTag;
import io.rsocket.rpc.metrics.om.MeterType;
import io.rsocket.rpc.metrics.om.MetricsSnapshot;
import io.rsocket.rpc.metrics.om.MetricsSnapshotHandler;
import io.rsocket.rpc.metrics.om.Skew;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public class MetricsExporter
implements Disposable,
Runnable {
    private final Logger logger = LoggerFactory.getLogger(MetricsExporter.class);
    private final MetricsSnapshotHandler handler;
    private final MeterRegistry registry;
    private final Duration exportFrequency;
    private final int batchSize;
    private volatile Disposable disposable;

    public MetricsExporter(MetricsSnapshotHandler handler, MeterRegistry registry, Duration exportFrequency, int batchSize) {
        this.handler = handler;
        this.registry = registry;
        this.exportFrequency = exportFrequency;
        this.batchSize = batchSize;
    }

    private static final String round(double percentile) {
        double roundOff = (double)Math.round(percentile * 10000.0) / 10000.0;
        return String.valueOf(roundOff);
    }

    private Flux<MetricsSnapshot> getMetricsSnapshotStream() {
        return Flux.fromIterable((Iterable)this.registry.getMeters()).window(this.batchSize).flatMap(meters -> meters.groupBy(meter -> {
            if (meter instanceof Timer) {
                return true;
            }
            return false;
        }).flatMap(grouped -> {
            if (((Boolean)grouped.key()).booleanValue()) {
                return grouped.reduce((Object)MetricsSnapshot.newBuilder(), (builder, meter) -> {
                    Timer timer = (Timer)meter;
                    List<Meter> convert = this.convert(timer);
                    builder.addAllMeters(convert);
                    return builder;
                });
            }
            return grouped.reduce((Object)MetricsSnapshot.newBuilder(), (builder, meter) -> {
                Meter convert = this.convert((io.micrometer.core.instrument.Meter)meter);
                builder.addMeters(convert);
                return builder;
            });
        }).map(MetricsSnapshot.Builder::build));
    }

    private List<Meter> convert(Timer timer) {
        ValueAtPercentile[] valueAtPercentiles;
        ArrayList<Meter> meters = new ArrayList<Meter>();
        HistogramSnapshot snapshot = timer.takeSnapshot();
        Meter.Id id = timer.getId();
        Meter.Type type = id.getType();
        List meterTags = StreamSupport.stream(id.getTags().spliterator(), false).map(tag -> MeterTag.newBuilder().setKey(tag.getKey()).setValue(tag.getValue()).build()).collect(Collectors.toList());
        for (ValueAtPercentile percentile : valueAtPercentiles = snapshot.percentileValues()) {
            Meter.Builder meterBuilder = Meter.newBuilder();
            double value = percentile.value(TimeUnit.NANOSECONDS);
            MeterTag tag2 = MeterTag.newBuilder().setKey("percentile").setValue(MetricsExporter.round(percentile.percentile())).build();
            MeterId.Builder idBuilder = MeterId.newBuilder();
            idBuilder.setName(id.getName());
            idBuilder.addAllTag(meterTags);
            idBuilder.setType(this.convert(type));
            if (id.getDescription() != null) {
                idBuilder.setDescription(id.getDescription());
            }
            idBuilder.setBaseUnit("nanoseconds");
            idBuilder.addTag(tag2);
            meterBuilder.setId(idBuilder);
            meterBuilder.addMeasure(MeterMeasurement.newBuilder().setValue(value).setStatistic(MeterStatistic.DURATION));
            Meter meter = meterBuilder.build();
            meters.add(meter);
        }
        Meter convert = this.convert((io.micrometer.core.instrument.Meter)timer);
        meters.add(convert);
        return meters;
    }

    private Meter convert(io.micrometer.core.instrument.Meter meter) {
        Meter.Builder meterBuilder = Meter.newBuilder();
        MeterId.Builder idBuilder = MeterId.newBuilder();
        Meter.Id id = meter.getId();
        Meter.Type type = id.getType();
        for (Tag tag : id.getTags()) {
            idBuilder.addTag(MeterTag.newBuilder().setKey(tag.getKey()).setValue(tag.getValue()));
        }
        idBuilder.setName(id.getName());
        idBuilder.setType(this.convert(type));
        if (id.getDescription() != null) {
            idBuilder.setDescription(id.getDescription());
        }
        if (id.getBaseUnit() != null) {
            idBuilder.setBaseUnit(id.getBaseUnit());
        }
        meterBuilder.setId(idBuilder);
        for (Measurement measurement : meter.measure()) {
            meterBuilder.addMeasure(MeterMeasurement.newBuilder().setValue(measurement.getValue()).setStatistic(this.convert(measurement.getStatistic())));
        }
        return meterBuilder.build();
    }

    private MeterType convert(Meter.Type type) {
        switch (type) {
            case GAUGE: {
                return MeterType.GAUGE;
            }
            case TIMER: {
                return MeterType.TIMER;
            }
            case COUNTER: {
                return MeterType.COUNTER;
            }
            case LONG_TASK_TIMER: {
                return MeterType.LONG_TASK_TIMER;
            }
            case DISTRIBUTION_SUMMARY: {
                return MeterType.DISTRIBUTION_SUMMARY;
            }
            case OTHER: {
                return MeterType.OTHER;
            }
        }
        throw new IllegalStateException("unknown type " + type.name());
    }

    private MeterStatistic convert(Statistic statistic) {
        switch (statistic) {
            case MAX: {
                return MeterStatistic.MAX;
            }
            case COUNT: {
                return MeterStatistic.COUNT;
            }
            case TOTAL: {
                return MeterStatistic.TOTAL;
            }
            case VALUE: {
                return MeterStatistic.VALUE;
            }
            case UNKNOWN: {
                return MeterStatistic.UNKNOWN;
            }
            case DURATION: {
                return MeterStatistic.DURATION;
            }
            case TOTAL_TIME: {
                return MeterStatistic.TOTAL_TIME;
            }
            case ACTIVE_TASKS: {
                return MeterStatistic.ACTIVE_TASKS;
            }
        }
        throw new IllegalStateException("unknown type " + statistic.name());
    }

    private void recordClockSkew(Skew skew) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Disposable d;
        MetricsExporter metricsExporter = this;
        synchronized (metricsExporter) {
            d = this.disposable;
            this.disposable = null;
        }
        d.dispose();
    }

    public boolean isDisposed() {
        if (this.disposable != null) {
            return false;
        }
        return this.disposable.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MetricsExporter metricsExporter = this;
        synchronized (metricsExporter) {
            if (this.disposable != null) {
                return;
            }
        }
        this.disposable = Flux.interval((Duration)this.exportFrequency).onBackpressureDrop().concatMap(l -> this.handler.streamMetrics((Publisher<MetricsSnapshot>)this.getMetricsSnapshotStream(), Unpooled.EMPTY_BUFFER).doOnNext(this::recordClockSkew)).doOnError(throwable -> this.logger.debug("error streaming metrics", throwable)).retry().subscribe();
    }
}

