/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.rpc.tracing;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapInjectAdapter;
import io.rsocket.rpc.tracing.SpanSubscription;
import io.rsocket.rpc.tracing.Tag;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

final class SpanSubscriber<T>
extends AtomicBoolean
implements SpanSubscription<T> {
    private static final Logger log = Loggers.getLogger(SpanSubscriber.class);
    private final Span span;
    private final Span rootSpan;
    private final Subscriber<? super T> subscriber;
    private final Context context;
    private final Tracer tracer;
    private Subscription s;

    SpanSubscriber(Subscriber<? super T> subscriber, Context ctx, Tracer tracer, Map<String, String> tracingMetadata, SpanContext spanContext, String name, Tag ... tags) {
        this.subscriber = subscriber;
        this.tracer = tracer;
        this.rootSpan = null;
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(name).asChildOf(spanContext);
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                spanBuilder.withTag(tag.getKey(), tag.getValue());
            }
        }
        this.span = spanBuilder.start();
        if (tracingMetadata != null) {
            TextMapInjectAdapter adapter = new TextMapInjectAdapter(tracingMetadata);
            tracer.inject(this.span.context(), Format.Builtin.TEXT_MAP, (Object)adapter);
        }
        if (log.isTraceEnabled()) {
            log.trace("Created span [{}], with name [{}], child of [{}]", new Object[]{this.span, name, spanContext.toString()});
        }
        this.context = ctx.put(Span.class, (Object)this.span);
    }

    SpanSubscriber(Subscriber<? super T> subscriber, Context ctx, Tracer tracer, Map<String, String> tracingMetadata, String name, Tag ... tags) {
        this.subscriber = subscriber;
        this.tracer = tracer;
        Span root = (Span)ctx.getOrDefault(Span.class, (Object)this.tracer.activeSpan());
        if (log.isTraceEnabled()) {
            log.trace("Span from context [{}]", new Object[]{root});
        }
        this.rootSpan = root;
        if (log.isTraceEnabled()) {
            log.trace("Stored context root span [{}]", new Object[]{this.rootSpan});
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(name);
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                spanBuilder.withTag(tag.getKey(), tag.getValue());
            }
        }
        if (root != null) {
            spanBuilder.asChildOf(root);
        }
        this.span = spanBuilder.start();
        if (tracingMetadata != null) {
            TextMapInjectAdapter adapter = new TextMapInjectAdapter(tracingMetadata);
            tracer.inject(this.span.context(), Format.Builtin.TEXT_MAP, (Object)adapter);
        }
        if (log.isTraceEnabled()) {
            log.trace("Created span [{}], with name [{}]", new Object[]{this.span, name});
        }
        this.context = ctx.put(Span.class, (Object)this.span);
    }

    public void onSubscribe(Subscription subscription) {
        if (log.isTraceEnabled()) {
            log.trace("On subscribe");
        }
        this.s = subscription;
        try (Scope scope = this.tracer.scopeManager().activate(this.span, false);){
            scope.span().log(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()), "onSubscribe");
            if (log.isTraceEnabled()) {
                log.trace("On subscribe - span continued");
            }
            this.subscriber.onSubscribe((Subscription)this);
        }
    }

    public void request(long n) {
        if (log.isTraceEnabled()) {
            log.trace("Request");
        }
        if (log.isTraceEnabled()) {
            log.trace("Request - continued");
        }
        this.s.request(n);
        if (log.isTraceEnabled()) {
            log.trace("Request after cleaning. Current span [{}]", new Object[]{this.tracer.activeSpan()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        try (Scope scope = this.tracer.scopeManager().activate(this.span, false);){
            scope.span().log(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()), "cancel");
            if (log.isTraceEnabled()) {
                log.trace("Cancel");
            }
            this.s.cancel();
        }
        finally {
            this.cleanup();
        }
    }

    public void onNext(T o) {
        this.subscriber.onNext(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable throwable) {
        try (Scope scope = this.tracer.scopeManager().activate(this.span, false);){
            scope.span().log(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()), "onError");
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete() {
        try (Scope scope = this.tracer.scopeManager().activate(this.span, false);){
            scope.span().log(TimeUnit.MILLISECONDS.toMicros(System.currentTimeMillis()), "onComplete");
            this.subscriber.onComplete();
        }
        finally {
            this.cleanup();
        }
    }

    void cleanup() {
        if (this.compareAndSet(false, true)) {
            if (log.isTraceEnabled()) {
                log.trace("Cleaning up");
            }
            this.span.finish();
            if (log.isTraceEnabled()) {
                log.trace("Span closed");
            }
            if (this.rootSpan != null) {
                this.rootSpan.finish();
                if (log.isTraceEnabled()) {
                    log.trace("Closed root span");
                }
            }
        }
    }

    public Context currentContext() {
        return this.context;
    }
}

