/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges;

import java.net.URI;
import java.net.URISyntaxException;
import javax.websocket.ContainerProvider;
import javax.websocket.WebSocketContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;

public abstract class ExchangeWebSocketHandler
implements WebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(ExchangeWebSocketHandler.class);
    protected WebSocketSession webSocketSession = null;
    private final String id;
    private final String wssAddress;
    private String subscribeMessage = null;
    private String[] subscribeMessages = null;
    private boolean isClose = false;

    public ExchangeWebSocketHandler(String id, String wssAddress) {
        this.id = id;
        this.wssAddress = wssAddress;
    }

    public ExchangeWebSocketHandler(String id, String wssAddress, String subscribeMessage) {
        this.id = id;
        this.wssAddress = wssAddress;
        this.subscribeMessage = subscribeMessage;
    }

    public ExchangeWebSocketHandler(String id, String wssAddress, String[] subscribeMessages) {
        this.id = id;
        this.wssAddress = wssAddress;
        this.subscribeMessages = subscribeMessages;
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        this.webSocketSession = session;
        log.debug("afterConnectionEstablished " + session.getId() + ", id: " + this.id);
        if (this.subscribeMessage != null) {
            this.webSocketSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.subscribeMessage));
        }
        if (this.subscribeMessages != null && this.subscribeMessages.length > 0) {
            if (this.subscribeMessage != null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.webSocketSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.subscribeMessages[0]));
            for (int i = 1; i < this.subscribeMessages.length; ++i) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.webSocketSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)this.subscribeMessages[i]));
            }
        }
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) {
        log.error("handleTransportError " + exception.getMessage() + ", id: " + this.id);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) {
        log.info("afterConnectionClosed " + session.getId() + " closeStatus " + closeStatus.toString() + ", id: " + this.id);
    }

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) {
        String data = message.getPayload().toString();
        log.info(this.id + " handle message: " + data);
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    public void connect() {
        try {
            this.isClose = false;
            URI uri = new URI(this.wssAddress);
            WebSocketHttpHeaders headers = new WebSocketHttpHeaders();
            WebSocketContainer webSocketContainer = ContainerProvider.getWebSocketContainer();
            webSocketContainer.setDefaultMaxTextMessageBufferSize(0x100000);
            ListenableFuture listenableFuture = new StandardWebSocketClient(webSocketContainer).doHandshake((WebSocketHandler)this, headers, uri);
            listenableFuture.addCallback(result -> {
                this.webSocketSession = result;
            }, ex -> log.error("WebSocketClient connect failed, error:{}, type{}, id: " + this.id, (Object)ex.getMessage(), (Object)ex.getClass().getCanonicalName()));
        }
        catch (URISyntaxException e) {
            log.error("server url syntax error:{}, type:{}", (Object)e.getMessage(), (Object)e.getClass().getCanonicalName());
        }
        catch (Exception e) {
            log.error("WebsocketClient init error:{}, type:{}", (Object)e.getMessage(), (Object)e.getClass().getCanonicalName());
        }
    }

    public boolean isClose() {
        return this.isClose;
    }

    public void close() {
        try {
            this.isClose = true;
            if (this.webSocketSession != null) {
                this.webSocketSession.close();
                this.webSocketSession = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void setSubscribeMessages(String[] subscribeMessages) {
        this.subscribeMessages = subscribeMessages;
    }
}

