/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExchangeWebSocketListener
extends WebSocketListener {
    private static final Logger log = LoggerFactory.getLogger(ExchangeWebSocketListener.class);
    protected final String id;
    protected final String wssAddress;
    private String subscribeMessage = null;
    private String[] subscribeMessages = null;
    protected WebSocket webSocket = null;
    protected OkHttpClient client = null;
    protected boolean isClose = false;

    public ExchangeWebSocketListener(String id, String wssAddress) {
        this.id = id;
        this.wssAddress = wssAddress;
    }

    public ExchangeWebSocketListener(String id, String wssAddress, String subscribeMessage) {
        this.id = id;
        this.wssAddress = wssAddress;
        this.subscribeMessage = subscribeMessage;
    }

    public ExchangeWebSocketListener(String id, String wssAddress, String[] subscribeMessages) {
        this.id = id;
        this.wssAddress = wssAddress;
        this.subscribeMessages = subscribeMessages;
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void setSubscribeMessages(String[] subscribeMessages) {
        this.subscribeMessages = subscribeMessages;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        log.debug("onOpen response:" + this.id);
    }

    public void onMessage(WebSocket webSocket, String text) {
        log.info(this.id + " on message: " + text);
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        log.debug("onClosing code:" + code + ", reason:" + reason + ", " + this.id);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        if (code == 1000) {
            log.debug("onClosed code:" + code + ", reason:" + reason + ", " + this.id);
        } else {
            log.error("onClosed code:" + code + ", reason:" + reason + ", " + this.id);
        }
    }

    public void connect() {
        this.isClose = false;
        this.client = new OkHttpClient();
        Request request = new Request.Builder().url(this.wssAddress).build();
        this.webSocket = this.client.newWebSocket(request, (WebSocketListener)this);
        if (this.subscribeMessage != null) {
            this.webSocket.send(this.subscribeMessage);
        }
        if (this.subscribeMessages != null && this.subscribeMessages.length > 0) {
            if (this.subscribeMessage != null) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.webSocket.send(this.subscribeMessages[0]);
            for (int i = 1; i < this.subscribeMessages.length; ++i) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.webSocket.send(this.subscribeMessages[i]);
            }
        }
    }

    public boolean isClose() {
        return this.isClose;
    }

    public void close() {
        if (this.webSocket != null) {
            try {
                this.webSocket.close(1000, null);
                this.webSocket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.client.dispatcher().executorService().shutdown();
                this.client = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isClose = true;
    }
}

