/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance;

import com.seomse.commons.config.Config;
import com.seomse.commons.exception.IORuntimeException;
import com.seomse.commons.utils.FileUtil;
import com.seomse.crawling.core.http.HttpUrl;
import io.runon.trading.CandleTimes;
import io.runon.trading.data.csv.CsvCommon;
import io.runon.trading.data.csv.CsvTimeName;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import java.io.File;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;

public class BinanceCandle {
    public static final String CANDLE = "https://api.binance.com/api/v3/klines?symbol=%s&interval=%s";
    public static final String FUTURES_CANDLE = "https://fapi.binance.com/fapi/v1/klines?symbol=%s&interval=%s";

    public static void csv(String url, String outPath, String symbol, String interval, Long startTime, Long endTime, Integer limit) {
        StringBuilder sb = new StringBuilder();
        JSONArray array = new JSONArray(BinanceCandle.jsonArray(url, symbol, interval, startTime, endTime, limit));
        int length = array.length();
        for (int i = 0; i < length; ++i) {
            JSONArray data = array.getJSONArray(i);
            sb.append("\n").append(BinanceCandle.getCsv(data));
        }
        if (FileUtil.isFile((String)outPath)) {
            FileUtil.fileOutput((String)sb.toString(), (String)outPath, (boolean)true);
        } else {
            FileUtil.fileOutput((String)sb.substring(1), (String)outPath, (boolean)false);
        }
    }

    public static String getCsv(JSONArray data) {
        return data.getLong(0) + "," + data.getBigDecimal(4).stripTrailingZeros().toPlainString() + "," + data.getBigDecimal(1).stripTrailingZeros().toPlainString() + "," + data.getBigDecimal(2).stripTrailingZeros().toPlainString() + "," + data.getBigDecimal(3).stripTrailingZeros().toPlainString() + "," + data.getBigDecimal(1).stripTrailingZeros().toPlainString() + "," + data.getBigDecimal(5).stripTrailingZeros().toPlainString() + "," + data.getBigDecimal(7).stripTrailingZeros().toPlainString() + "," + data.getInt(8) + "," + data.getBigDecimal(9).stripTrailingZeros().toPlainString() + "," + data.getBigDecimal(10).stripTrailingZeros().toPlainString();
    }

    public static void csv(String url, String outPath, String symbol, long time, long startTime, int count) {
        JSONArray array;
        int length;
        int total = 0;
        String interval = CandleTimes.getInterval((long)time);
        block2: while ((length = (array = new JSONArray(BinanceCandle.jsonArray(url, symbol, interval, startTime, null, 1000))).length()) != 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                JSONArray data = array.getJSONArray(i);
                long nextTime = data.getLong(0) + time;
                if (startTime == nextTime) break block2;
                sb.append("\n").append(BinanceCandle.getCsv(data));
                startTime = nextTime;
                if (++total < count) continue;
                if (FileUtil.isFile((String)outPath)) {
                    FileUtil.fileOutput((String)sb.toString(), (String)outPath, (boolean)true);
                    break block2;
                }
                FileUtil.fileOutput((String)sb.substring(1), (String)outPath, (boolean)false);
                break block2;
            }
            if (FileUtil.isFile((String)outPath)) {
                FileUtil.fileOutput((String)sb.toString(), (String)outPath, (boolean)true);
            } else {
                FileUtil.fileOutput((String)sb.substring(1), (String)outPath, (boolean)false);
            }
            try {
                Thread.sleep(Config.getLong((String)"binance.candle.collect.sleep.time", (Long)300L));
            }
            catch (Exception exception) {}
        }
    }

    public static void csvNext(String url, String symbol, long candleTime, long startOpenTime) {
        if (url.startsWith("https://fapi.binance.com")) {
            BinanceCandle.csvNext(url, symbol, candleTime, CandleTimes.UTC_ZONE_ID, Config.getConfig((String)"cryptocurrency.futures.candle.dir.path", (String)"data/cryptocurrency/futures/candle"), startOpenTime);
        } else {
            BinanceCandle.csvNext(url, symbol, candleTime, CandleTimes.UTC_ZONE_ID, Config.getConfig((String)"cryptocurrency.spot.candle.dir.path", (String)"data/cryptocurrency/spot/candle"), startOpenTime);
        }
    }

    public static void csvNext(String url, String symbol, long candleTime, ZoneId zoneId, String outDirPath, long startOpenTime) {
        long lastOpenTime = CsvCommon.getLastOpenTime((String)(outDirPath + "/" + symbol + "/" + CandleTimes.getInterval((long)candleTime)));
        if (lastOpenTime == -1L) {
            BinanceCandle.csvSplit(url, symbol, candleTime, zoneId, outDirPath, startOpenTime);
        } else {
            BinanceCandle.csvSplit(url, symbol, candleTime, zoneId, outDirPath, lastOpenTime);
        }
    }

    public static void csvSplit(String url, String symbol, long candleTime, long startOpenTime) {
        if (url.startsWith("https://fapi.binance.com")) {
            BinanceCandle.csvSplit(url, symbol, candleTime, CandleTimes.UTC_ZONE_ID, Config.getConfig((String)"cryptocurrency.futures.candle.dir.path", (String)"data/cryptocurrency/futures/candle"), startOpenTime);
        } else {
            BinanceCandle.csvSplit(url, symbol, candleTime, CandleTimes.UTC_ZONE_ID, Config.getConfig((String)"cryptocurrency.spot.candle.dir.path", (String)"data/cryptocurrency/spot/candle"), startOpenTime);
        }
    }

    public static void csvSplit(String url, String symbol, long candleTime, ZoneId zoneId, String outDirPath, long startOpenTime) {
        JSONArray array;
        int length;
        File dirFile;
        String interval = CandleTimes.getInterval((long)candleTime);
        if (!((String)outDirPath).endsWith("/") || !((String)outDirPath).endsWith("\\")) {
            outDirPath = (String)outDirPath + "/";
        }
        if (!(dirFile = new File((String)(outDirPath = (String)outDirPath + symbol + "/" + interval + "/"))).isDirectory()) {
            dirFile.mkdirs();
        }
        StringBuilder sb = null;
        Object lastOutPath = null;
        block2: while ((length = (array = new JSONArray(BinanceCandle.jsonArray(url, symbol, interval, startOpenTime, null, 1000))).length()) != 0) {
            for (int i = 0; i < length; ++i) {
                JSONArray data = array.getJSONArray(i);
                long openTime = data.getLong(0);
                long nextTime = openTime + candleTime;
                if (startOpenTime == nextTime) break block2;
                String outPath = (String)outDirPath + CsvTimeName.getName((long)openTime, (long)candleTime, (ZoneId)zoneId);
                if (lastOutPath == null || !((String)lastOutPath).equals(outPath)) {
                    if (sb != null) {
                        FileUtil.fileOutput((String)sb.toString(), (String)lastOutPath, (boolean)false);
                        sb.setLength(0);
                    }
                    lastOutPath = outPath;
                    sb = null;
                }
                if (sb == null) {
                    int size;
                    sb = new StringBuilder();
                    List lineList = Collections.emptyList();
                    if (FileUtil.isFile((String)outPath)) {
                        lineList = FileUtil.getFileContentsList((File)new File(outPath), (String)"UTF-8");
                    }
                    if ((size = lineList.size()) == 0) {
                        sb.append(BinanceCandle.getCsv(data));
                    } else {
                        int index;
                        String line = (String)lineList.get(0);
                        long csvOpenTime = Long.parseLong(line.substring(0, index = line.indexOf(44)));
                        if (csvOpenTime >= openTime) {
                            sb.append(BinanceCandle.getCsv(data));
                        } else {
                            sb.append(line);
                            for (int j = 1; j < size && (csvOpenTime = Long.parseLong((line = (String)lineList.get(j)).substring(0, index = line.indexOf(44)))) < openTime; ++j) {
                                sb.append("\n").append(line);
                            }
                            sb.append("\n").append(BinanceCandle.getCsv(data));
                        }
                        lineList.clear();
                    }
                } else {
                    sb.append("\n").append(BinanceCandle.getCsv(data));
                }
                startOpenTime = nextTime;
            }
            try {
                Thread.sleep(Config.getLong((String)"binance.candle.collect.sleep.time", (Long)300L));
            }
            catch (Exception exception) {}
        }
        if (sb != null && sb.length() > 0) {
            FileUtil.fileOutput((String)sb.toString(), lastOutPath, (boolean)false);
        }
    }

    public static String jsonArray(String url, String symbol, String interval, Long startTime, Long endTime, Integer limit) {
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(url.formatted(symbol, interval));
        if (startTime != null) {
            queryBuilder.append("&startTime=").append(startTime);
        }
        if (endTime != null) {
            queryBuilder.append("&endTime=").append(endTime);
        }
        if (limit != null) {
            queryBuilder.append("&limit=").append(limit);
        }
        return HttpUrl.get((String)queryBuilder.toString());
    }

    public static TradeCandle[] candles(String url, String symbol, String interval, Long startTime, Long endTime, Integer limit) {
        JSONArray array = new JSONArray(BinanceCandle.jsonArray(url, symbol, interval, startTime, endTime, limit));
        TradeCandle[] candles = new TradeCandle[array.length()];
        long candleTime = CandleTimes.getIntervalTime((String)interval);
        for (int i = 0; i < candles.length; ++i) {
            JSONArray data = array.getJSONArray(i);
            long opeTime = data.getLong(0);
            TradeCandle tradeCandle = new TradeCandle();
            tradeCandle.setOpenTime(opeTime);
            tradeCandle.setCloseTime(opeTime + candleTime);
            tradeCandle.setClose(data.getBigDecimal(4));
            tradeCandle.setOpen(data.getBigDecimal(1));
            tradeCandle.setHigh(data.getBigDecimal(2));
            tradeCandle.setLow(data.getBigDecimal(3));
            tradeCandle.setPrevious(data.getBigDecimal(1));
            tradeCandle.setVolume(data.getBigDecimal(5));
            tradeCandle.setTradingPrice(data.getBigDecimal(7));
            tradeCandle.setTradeCount(data.getInt(8));
            tradeCandle.setBuyVolume(data.getBigDecimal(9));
            tradeCandle.setBuyTradingPrice(data.getBigDecimal(10));
            tradeCandle.setSellVolume();
            tradeCandle.setSellTradingPrice();
            tradeCandle.setChange();
            candles[i] = tradeCandle;
        }
        return candles;
    }

    public static void csv(String url, String inPath, String symbol) {
        if (!FileUtil.isFile((String)inPath)) {
            throw new IORuntimeException("file not found : " + inPath);
        }
        long lineCount = FileUtil.getLineCount((String)inPath);
        if (lineCount < 2L) {
            throw new IllegalArgumentException("file line count > 2 , count: " + lineCount);
        }
        String line = FileUtil.getLine((String)inPath, (int)0);
        long firstTime = Long.parseLong(line.split(",")[0]);
        line = FileUtil.getLine((String)inPath, (int)1);
        long time = Long.parseLong(line.split(",")[0]) - firstTime;
        line = FileUtil.getLine((String)inPath, (int)((int)(lineCount - 1L)));
        long lastTime = Long.parseLong(line.split(",")[0]);
        long startTime = lastTime + time;
        BinanceCandle.csv(url, inPath, symbol, time, startTime, Integer.MAX_VALUE);
    }
}

