/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.seomse.commons.utils.ExceptionUtil;
import io.runon.cryptocurrency.exchanges.ExchangeWebSocketListener;
import io.runon.cryptocurrency.exchanges.binance.BinanceExchange;
import io.runon.cryptocurrency.trading.CryptocurrencyCandle;
import io.runon.cryptocurrency.trading.DataStreamCandle;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.trading.technical.analysis.candle.TradeCandle;
import okhttp3.WebSocket;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinanceCandleStream<T extends CryptocurrencyCandle>
extends DataStreamCandle<T> {
    private static final Logger log = LoggerFactory.getLogger(BinanceCandleStream.class);
    protected String wssAddress = "wss://stream.binance.com:9443/ws";
    private ExchangeWebSocketListener webSocketListener;
    private String subscribeMessage = "{\"method\":\"SUBSCRIBE\",\"id\":1,\"params\":[\"btcusdt@kline_1d\"]}";
    private String interval = "1d";

    public BinanceCandleStream(String streamId) {
        super(streamId);
    }

    public MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        return BinanceExchange.getMarketSymbol(cryptocurrencyId);
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public void setMessage(String symbols, String markets) {
        String[] symbolArray = symbols.toLowerCase().split(",");
        String[] marketArray = markets.toLowerCase().split(",");
        JsonArray params = new JsonArray();
        for (String symbol : symbolArray) {
            for (String market : marketArray) {
                params.add(symbol + market + "@kline_" + this.interval);
            }
        }
        JsonObject object = new JsonObject();
        object.addProperty("method", "SUBSCRIBE");
        object.addProperty("id", (Number)1);
        object.add("params", (JsonElement)params);
        Gson gson = new Gson();
        this.subscribeMessage = gson.toJson((JsonElement)object);
    }

    public void connect() {
        this.close();
        this.webSocketListener = new ExchangeWebSocketListener(this.streamId, this.wssAddress, this.subscribeMessage){

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                if (this.isClose()) {
                    return;
                }
                try {
                    JSONObject messageObj = new JSONObject(text);
                    if (messageObj.isNull("e")) {
                        log.debug(text);
                        return;
                    }
                    if (!messageObj.getString("e").equals("kline")) {
                        log.debug(text);
                        return;
                    }
                    String id = messageObj.getString("s");
                    messageObj = messageObj.getJSONObject("k");
                    TradeCandle tradeCandle = new TradeCandle();
                    tradeCandle.setTradeRecord(false);
                    tradeCandle.setOpenTime(messageObj.getLong("t"));
                    tradeCandle.setCloseTime(messageObj.getLong("T") + 1L);
                    tradeCandle.setOpen(messageObj.getBigDecimal("o"));
                    tradeCandle.setClose(messageObj.getBigDecimal("c"));
                    tradeCandle.setHigh(messageObj.getBigDecimal("h"));
                    tradeCandle.setLow(messageObj.getBigDecimal("l"));
                    tradeCandle.setPrevious(tradeCandle.getOpen());
                    tradeCandle.setTradeCount(messageObj.getInt("n"));
                    tradeCandle.setVolume(messageObj.getBigDecimal("v"));
                    tradeCandle.setTradingPrice(messageObj.getBigDecimal("q"));
                    tradeCandle.setBuyVolume(messageObj.getBigDecimal("V"));
                    tradeCandle.setBuyTradingPrice(messageObj.getBigDecimal("Q"));
                    tradeCandle.setSellVolume(tradeCandle.getVolume().subtract(tradeCandle.getBuyVolume()));
                    tradeCandle.setSellTradingPrice(tradeCandle.getTradingPrice().subtract(tradeCandle.getBuyTradingPrice()));
                    BinanceCandleStream.this.addCandle(id, tradeCandle);
                }
                catch (Exception e) {
                    log.error(ExceptionUtil.getStackTrace((Exception)e));
                }
            }
        };
        this.webSocketListener.connect();
    }

    public void close() {
        try {
            if (this.webSocketListener != null) {
                this.webSocketListener.close();
                this.webSocketListener = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

