/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance;

import com.binance.client.SyncRequestClient;
import com.binance.client.model.market.MarkPrice;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.seomse.crawling.core.http.HttpUrl;
import io.runon.cryptocurrency.exchanges.binance.BinanceFuturesApis;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.cryptocurrency.trading.exception.IdNotPatternException;
import io.runon.trading.BigDecimals;
import io.runon.trading.symbol.SymbolNumber;
import io.runon.trading.symbol.SymbolPriceVolume;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class BinanceExchange {
    public static MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        MarketSymbol marketSymbol = new MarketSymbol();
        marketSymbol.setId(cryptocurrencyId);
        cryptocurrencyId = cryptocurrencyId.toUpperCase();
        if (cryptocurrencyId.endsWith("USDT")) {
            marketSymbol.setSymbol(cryptocurrencyId.substring(0, cryptocurrencyId.length() - 4));
            marketSymbol.setMarket("USDT");
        } else if (cryptocurrencyId.endsWith("BUSD")) {
            marketSymbol.setSymbol(cryptocurrencyId.substring(0, cryptocurrencyId.length() - 4));
            marketSymbol.setMarket("BUSD");
        } else if (cryptocurrencyId.endsWith("BTC")) {
            marketSymbol.setSymbol(cryptocurrencyId.substring(0, cryptocurrencyId.length() - 3));
            marketSymbol.setMarket("BTC");
        } else if (cryptocurrencyId.endsWith("ETH")) {
            marketSymbol.setSymbol(cryptocurrencyId.substring(0, cryptocurrencyId.length() - 3));
            marketSymbol.setMarket("ETH");
        } else if (cryptocurrencyId.endsWith("BNB")) {
            marketSymbol.setSymbol(cryptocurrencyId.substring(0, cryptocurrencyId.length() - 3));
            marketSymbol.setMarket("BNB");
        } else {
            throw new IdNotPatternException("id: " + cryptocurrencyId);
        }
        return marketSymbol;
    }

    public static String getTickers() {
        return HttpUrl.get((String)"https://api.binance.com/api/v3/ticker/price");
    }

    public static String getTickers24h() {
        return HttpUrl.get((String)"https://api.binance.com/api/v3/ticker/24hr");
    }

    public static Map<String, Integer> getSymbolRankingMap() {
        HashMap<String, SymbolPriceVolume> symbolNumberMap = new HashMap<String, SymbolPriceVolume>();
        String jsonValue = BinanceExchange.getTickers24h();
        JSONArray array = new JSONArray(jsonValue);
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.getJSONObject(i);
            String symbol = object.getString("symbol");
            if (symbol.length() < 4 || !symbol.endsWith("BUSD") && !symbol.endsWith("USDT")) continue;
            SymbolPriceVolume symbolPriceVolume = (SymbolPriceVolume)symbolNumberMap.get(symbol = symbol.substring(0, symbol.length() - 4));
            if (symbolPriceVolume == null) {
                symbolPriceVolume = new SymbolPriceVolume();
                symbolPriceVolume.setSymbol(symbol);
                symbolPriceVolume.setPrice(object.getBigDecimal("lastPrice").add(object.getBigDecimal("highPrice").add(object.getBigDecimal("lowPrice"))).divide(BigDecimals.DECIMAL_3, MathContext.DECIMAL128));
                symbolPriceVolume.setVolume(object.getBigDecimal("volume"));
                symbolNumberMap.put(symbol, symbolPriceVolume);
                continue;
            }
            if (symbol.endsWith("BUSD")) {
                symbolPriceVolume.setPrice(object.getBigDecimal("lastPrice").add(object.getBigDecimal("highPrice").add(object.getBigDecimal("lowPrice"))).divide(BigDecimals.DECIMAL_3, MathContext.DECIMAL128));
            }
            symbolPriceVolume.setVolume(symbolPriceVolume.getVolume().add(object.getBigDecimal("volume")));
        }
        Collection values = symbolNumberMap.values();
        SymbolNumber[] symbolNumbers = new SymbolNumber[values.size()];
        int index = 0;
        for (SymbolPriceVolume symbolPriceVolume : values) {
            SymbolNumber symbolNumber = new SymbolNumber();
            symbolNumber.setSymbol(symbolPriceVolume.getSymbol());
            symbolNumber.setNumber(symbolPriceVolume.getPrice().multiply(symbolPriceVolume.getVolume()));
            symbolNumbers[index++] = symbolNumber;
        }
        Arrays.sort(symbolNumbers, SymbolNumber.SORT_NUMBER_DESC_SYMBOL_ASC);
        HashMap<String, Integer> rankingMap = new HashMap<String, Integer>();
        int ranking = 1;
        BigDecimal lastNumber = symbolNumbers[0].getNumber();
        for (SymbolNumber symbolNumber : symbolNumbers) {
            if (symbolNumber.getNumber().compareTo(lastNumber) != 0) {
                ++ranking;
                lastNumber = symbolNumber.getNumber();
            }
            rankingMap.put(symbolNumber.getSymbol(), ranking);
        }
        return rankingMap;
    }

    public static List<MarkPrice> getFuturesTickers() {
        return BinanceExchange.getFuturesTickers("");
    }

    public static List<MarkPrice> getFuturesTickers(String symbol) {
        return SyncRequestClient.create().getMarkPrice(symbol);
    }

    public static String getSymbolMarket(String symbol, String market) {
        if (!((String)symbol).endsWith(market) && !((String)(symbol = ((String)symbol).toUpperCase())).endsWith(market)) {
            symbol = (String)symbol + market;
        }
        return symbol;
    }

    public static String getOrderBookLine(String binanceOrderBookJson) {
        return BinanceExchange.getOrderBookLine(new JSONObject(binanceOrderBookJson));
    }

    public static String getOrderBookLine(JSONObject binanceOrderBookJson) {
        long time = System.currentTimeMillis();
        JSONArray askArray = binanceOrderBookJson.getJSONArray("asks");
        JsonArray asks = new JsonArray();
        for (int i = 0; i < askArray.length(); ++i) {
            JSONArray pq = askArray.getJSONArray(i);
            JsonArray ask = new JsonArray();
            ask.add(pq.getBigDecimal(0).stripTrailingZeros().toPlainString());
            ask.add(pq.getBigDecimal(1).stripTrailingZeros().toPlainString());
            asks.add((JsonElement)ask);
        }
        JSONArray bidArray = binanceOrderBookJson.getJSONArray("bids");
        JsonArray bids = new JsonArray();
        for (int i = 0; i < bidArray.length(); ++i) {
            JSONArray pq = bidArray.getJSONArray(i);
            JsonArray bid = new JsonArray();
            bid.add(pq.getBigDecimal(0).stripTrailingZeros().toPlainString());
            bid.add(pq.getBigDecimal(1).stripTrailingZeros().toPlainString());
            bids.add((JsonElement)bid);
        }
        JsonObject outObj = new JsonObject();
        outObj.addProperty("t", (Number)time);
        outObj.add("asks", (JsonElement)asks);
        outObj.add("bids", (JsonElement)bids);
        outObj.addProperty("update_id", (Number)binanceOrderBookJson.getLong("lastUpdateId"));
        return new Gson().toJson((JsonElement)outObj);
    }

    public static void main(String[] args) {
        System.out.println(BinanceExchange.getOrderBookLine(BinanceFuturesApis.getOrderBook("BTCUSDT")));
    }
}

