/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance;

import com.binance.client.model.market.MarkPrice;
import com.binance.client.model.trade.AccountInformation;
import com.binance.client.model.trade.Asset;
import com.binance.client.model.trade.Order;
import com.seomse.crawling.core.http.HttpUrl;
import io.runon.cryptocurrency.exchanges.binance.BinanceExchange;
import io.runon.trading.account.FuturesPosition;
import io.runon.trading.account.FuturesPositionData;
import io.runon.trading.strategy.Position;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.List;
import java.util.Objects;

public class BinanceFuturesApis {
    public static final String URL = "https://fapi.binance.com";

    public static BigDecimal getUsdtAsset(AccountInformation accountInformation) {
        return BinanceFuturesApis.getAsset("USDT", accountInformation);
    }

    public static BigDecimal getUsdtCash(AccountInformation accountInformation) {
        return BinanceFuturesApis.getCash("USDT", accountInformation);
    }

    public static BigDecimal getAsset(String currency, AccountInformation accountInformation) {
        Asset binanceAsset = BinanceFuturesApis.getBinanceAsset(currency, accountInformation);
        if (binanceAsset == null) {
            return BigDecimal.ZERO;
        }
        return binanceAsset.getMarginBalance();
    }

    public static BigDecimal getCash(String currency, AccountInformation accountInformation) {
        Asset binanceAsset = BinanceFuturesApis.getBinanceAsset(currency, accountInformation);
        if (binanceAsset == null) {
            return BigDecimal.ZERO;
        }
        return binanceAsset.getMaxWithdrawAmount();
    }

    public static Asset getBinanceAsset(String currency, AccountInformation accountInformation) {
        List list = accountInformation.getAssets();
        Asset binanceAsset = null;
        for (Asset asset : list) {
            if (!asset.getAsset().equals(currency)) continue;
            binanceAsset = asset;
            break;
        }
        return binanceAsset;
    }

    public static BigDecimal getTradePrice(Order order, int scale) {
        return BigDecimal.ONE.divide(order.getExecutedQty(), MathContext.DECIMAL128).multiply(order.getCumQuote()).setScale(scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public static com.binance.client.model.trade.Position getBinancePosition(String symbol, AccountInformation accountInformation) {
        List positions = accountInformation.getPositions();
        com.binance.client.model.trade.Position symbolPosition = null;
        for (com.binance.client.model.trade.Position position : positions) {
            if (!position.getSymbol().equals(symbol)) continue;
            symbolPosition = position;
            break;
        }
        return symbolPosition;
    }

    public static FuturesPosition getPosition(String symbol, AccountInformation accountInformation) {
        Position p;
        FuturesPositionData futuresPosition = new FuturesPositionData();
        futuresPosition.setSymbol(symbol);
        com.binance.client.model.trade.Position symbolPosition = BinanceFuturesApis.getBinancePosition(symbol, accountInformation);
        if (symbolPosition == null) {
            return futuresPosition;
        }
        futuresPosition.setPrice(new BigDecimal(symbolPosition.getEntryPrice()));
        futuresPosition.setTradingPrice(symbolPosition.getInitialMargin());
        futuresPosition.setLeverage(symbolPosition.getLeverage());
        futuresPosition.setQuantity(symbolPosition.getPositionAmt());
        if (futuresPosition.getPrice().compareTo(BigDecimal.ZERO) == 0) {
            p = Position.NONE;
        } else {
            BigDecimal amt = symbolPosition.getPositionAmt();
            p = symbolPosition.getPositionAmt().compareTo(BigDecimal.ZERO) < 0 ? Position.SHORT : (symbolPosition.getPositionAmt().compareTo(BigDecimal.ZERO) > 0 ? Position.LONG : Position.NONE);
        }
        futuresPosition.setPosition(p);
        return futuresPosition;
    }

    public static String getOpenInterest(String symbol) {
        return HttpUrl.get((String)("https://fapi.binance.com/fapi/v1/openInterest?symbol=" + symbol));
    }

    public static String getOpenInterestStatistics(String symbol, String period, Integer limit, Long startTime, Long endTime) {
        return BinanceFuturesApis.get("/futures/data/openInterestHist", symbol, period, limit, startTime, endTime);
    }

    public static String getLongShortRatio(String symbol, String period, Integer limit, Long startTime, Long endTime) {
        return BinanceFuturesApis.get("/futures/data/globalLongShortAccountRatio", symbol, period, limit, startTime, endTime);
    }

    public static String getTopLongShortRatioAccount(String symbol, String period, Integer limit, Long startTime, Long endTime) {
        return BinanceFuturesApis.get("/futures/data/topLongShortAccountRatio", symbol, period, limit, startTime, endTime);
    }

    public static String getTopLongShortRatioPositions(String symbol, String period, Integer limit, Long startTime, Long endTime) {
        return BinanceFuturesApis.get("/futures/data/topLongShortPositionRatio", symbol, period, limit, startTime, endTime);
    }

    public static String get(String api, String symbol, String period, Integer limit, Long startTime, Long endTime) {
        StringBuilder sb = new StringBuilder();
        sb.append(URL).append(api).append("?symbol=").append(symbol).append("&period=");
        sb.append(Objects.requireNonNullElse(period, "5m"));
        if (limit != null) {
            sb.append("&").append("limit=").append(limit);
        }
        if (startTime != null) {
            sb.append("&").append("startTime=").append(startTime);
        }
        if (endTime != null) {
            sb.append("&").append("endTime=").append(endTime);
        }
        return HttpUrl.get((String)sb.toString());
    }

    public static String getOrderBook(String symbol) {
        return HttpUrl.get((String)("https://fapi.binance.com/fapi/v1/depth?symbol=" + symbol));
    }

    public static String[] getAllSymbols() {
        List<MarkPrice> list = BinanceExchange.getFuturesTickers();
        String[] allSymbols = new String[list.size()];
        for (int i = 0; i < allSymbols.length; ++i) {
            allSymbols[i] = list.get(i).getSymbol();
        }
        return allSymbols;
    }

    public static void main(String[] args) {
        System.out.println(BinanceFuturesApis.getOrderBook("BTCUSDT"));
    }
}

