/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance;

import com.seomse.commons.config.Config;
import com.seomse.commons.exception.IORuntimeException;
import com.seomse.commons.utils.ExceptionUtil;
import io.runon.cryptocurrency.exchanges.binance.BinanceCandle;
import io.runon.cryptocurrency.exchanges.binance.BinanceFuturesApis;
import io.runon.cryptocurrency.trading.CandleOut;
import io.runon.trading.CandleTimes;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinanceFuturesCandleOut
extends CandleOut {
    private static final Logger log = LoggerFactory.getLogger(BinanceFuturesCandleOut.class);
    private int tryMaxCount = 10;

    public BinanceFuturesCandleOut() {
        this.outDirPath = Config.getConfig((String)"cryptocurrency.futures.candle.dir.path", (String)"data/cryptocurrency/futures/candle");
    }

    public String[] getAllSymbols() {
        return BinanceFuturesApis.getAllSymbols();
    }

    public void setTryMaxCount(int tryMaxCount) {
        this.tryMaxCount = tryMaxCount;
    }

    public void out() {
        log.info("symbol length: " + this.symbols.length);
        for (String symbol : this.symbols) {
            block8: for (long candleTime : this.candleTimes) {
                int tryCount = 0;
                while (true) {
                    if (tryCount >= this.tryMaxCount) {
                        log.error("symbol try over error : " + symbol + ", interval: " + CandleTimes.getInterval((long)candleTime) + ", try count: " + tryCount);
                        continue block8;
                    }
                    try {
                        log.info("start symbol: " + symbol + ", interval: " + CandleTimes.getInterval((long)candleTime) + ", try count: " + ++tryCount);
                        BinanceCandle.csvNext("https://fapi.binance.com/fapi/v1/klines?symbol=%s&interval=%s", symbol, candleTime, this.zoneId, this.outDirPath, this.startOpenTime);
                        continue block8;
                    }
                    catch (IORuntimeException | JSONException e) {
                        if (tryCount > 10) {
                            log.error("candle out error symbol: " + symbol + ", interval: " + CandleTimes.getInterval((long)candleTime) + ", try count: " + tryCount);
                            continue block8;
                        }
                        if (tryCount > 5) {
                            try {
                                Thread.sleep(900000L);
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                        try {
                            Thread.sleep(300000L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    catch (Exception e) {
                        log.error(ExceptionUtil.getStackTrace((Exception)e));
                    }
                    break;
                }
            }
        }
    }
}

