/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance;

import com.seomse.commons.exception.IORuntimeException;
import com.seomse.crawling.core.http.HttpUrl;
import io.runon.cryptocurrency.exchanges.binance.BinanceFuturesApis;

public class BinanceFuturesReTryApis {
    public static String getOpenInterest(int tryCount, long sleepTime, String symbol) {
        int check = tryCount - 1;
        for (int i = 0; i < check; ++i) {
            try {
                return HttpUrl.get((String)("https://fapi.binance.com/fapi/v1/openInterest?symbol=" + symbol));
            }
            catch (IORuntimeException e) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return HttpUrl.get((String)("https://fapi.binance.com/fapi/v1/openInterest?symbol=" + symbol));
    }

    public static String getOpenInterestStatistics(int tryCount, long sleepTime, String symbol, String period, Integer limit, Long startTime, Long endTime) {
        int check = tryCount - 1;
        for (int i = 0; i < check; ++i) {
            try {
                return BinanceFuturesApis.get("/futures/data/openInterestHist", symbol, period, limit, startTime, endTime);
            }
            catch (IORuntimeException e) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return BinanceFuturesApis.get("/futures/data/openInterestHist", symbol, period, limit, startTime, endTime);
    }

    public static String getLongShortRatio(int tryCount, long sleepTime, String symbol, String period, Integer limit, Long startTime, Long endTime) {
        int check = tryCount - 1;
        for (int i = 0; i < check; ++i) {
            try {
                return BinanceFuturesApis.get("/futures/data/globalLongShortAccountRatio", symbol, period, limit, startTime, endTime);
            }
            catch (IORuntimeException e) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return BinanceFuturesApis.get("/futures/data/globalLongShortAccountRatio", symbol, period, limit, startTime, endTime);
    }

    public static String getTopLongShortRatioAccount(int tryCount, long sleepTime, String symbol, String period, Integer limit, Long startTime, Long endTime) {
        int check = tryCount - 1;
        for (int i = 0; i < check; ++i) {
            try {
                return BinanceFuturesApis.get("/futures/data/topLongShortAccountRatio", symbol, period, limit, startTime, endTime);
            }
            catch (IORuntimeException e) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return BinanceFuturesApis.get("/futures/data/topLongShortAccountRatio", symbol, period, limit, startTime, endTime);
    }

    public static String getTopLongShortRatioPositions(int tryCount, long sleepTime, String symbol, String period, Integer limit, Long startTime, Long endTime) {
        int check = tryCount - 1;
        for (int i = 0; i < check; ++i) {
            try {
                return BinanceFuturesApis.get("/futures/data/topLongShortPositionRatio", symbol, period, limit, startTime, endTime);
            }
            catch (IORuntimeException e) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                continue;
            }
        }
        return BinanceFuturesApis.get("/futures/data/topLongShortPositionRatio", symbol, period, limit, startTime, endTime);
    }
}

