/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance;

import com.seomse.commons.exception.IORuntimeException;
import com.seomse.commons.utils.ExceptionUtil;
import com.seomse.commons.utils.FileUtil;
import io.runon.cryptocurrency.exchanges.binance.BinanceExchange;
import io.runon.cryptocurrency.trading.SymbolsData;
import io.runon.trading.CandleTimes;
import io.runon.trading.data.file.TimeFiles;
import io.runon.trading.data.file.TimeName;
import java.io.File;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinanceOrderBookOut
extends SymbolsData {
    private static final Logger log = LoggerFactory.getLogger(BinanceOrderBookOut.class);
    protected Map<String, Long> lastUpdateMap = new HashMap<String, Long>();
    protected TimeName.Type timeNameType = TimeName.Type.DAY_1;
    protected long sleepTime = 1000L;
    protected int tryMaxCount = 10;

    public void setTimeNameType(TimeName.Type timeNameType) {
        this.timeNameType = timeNameType;
    }

    public void initUpdateMap() {
        File file = new File(this.outDirPath);
        if (!file.isDirectory()) {
            return;
        }
        File[] symbolDirs = file.listFiles();
        if (symbolDirs == null || symbolDirs.length == 0) {
            return;
        }
        for (File symbolDir : symbolDirs) {
            String line;
            if (!symbolDir.isDirectory() || (line = TimeFiles.getLastLine((String)symbolDir.getAbsolutePath())) == null) continue;
            this.lastUpdateMap.put(symbolDir.getName(), new JSONObject(line).getLong("last_id"));
        }
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setTryMaxCount(int tryMaxCount) {
        this.tryMaxCount = tryMaxCount;
    }

    public void out() {
        block9: for (String symbol : this.symbols) {
            String symbolDirPath = this.outDirPath + "/" + symbol;
            new File(symbolDirPath).mkdirs();
            int tryCount = 0;
            while (true) {
                if (tryCount >= this.tryMaxCount) {
                    log.error("symbol try over error : " + symbol + ", try count: " + tryCount);
                    continue block9;
                }
                try {
                    if (++tryCount > 1) {
                        log.info("start symbol: " + symbol + ", try count: " + tryCount);
                    }
                    String jsonValue = this.getJsonValue(symbol);
                    JSONObject binanceOrderBookJson = new JSONObject(jsonValue);
                    long updateId = binanceOrderBookJson.getLong("lastUpdateId");
                    Long lastUpdateId = this.lastUpdateMap.get(symbol);
                    if (lastUpdateId != null && lastUpdateId == updateId) continue;
                    String line = BinanceExchange.getOrderBookLine(binanceOrderBookJson);
                    String name = TimeName.getName((long)System.currentTimeMillis(), (TimeName.Type)this.timeNameType, (ZoneId)CandleTimes.UTC_ZONE_ID);
                    String path = symbolDirPath + "/" + name;
                    File file = new File(path);
                    if (file.isFile()) {
                        FileUtil.fileOutput((String)("\n" + line), (String)path, (boolean)true);
                    } else {
                        FileUtil.fileOutput((String)line, (String)path, (boolean)false);
                    }
                    this.lastUpdateMap.put(symbol, updateId);
                    try {
                        Thread.sleep(this.sleepTime);
                    }
                    catch (Exception exception) {}
                    continue block9;
                }
                catch (IORuntimeException | JSONException e) {
                    if (tryCount > 10) {
                        log.error("candle out error symbol: " + symbol + ", try count: " + tryCount);
                        continue block9;
                    }
                    if (tryCount > 5) {
                        try {
                            Thread.sleep(300000L);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    try {
                        Thread.sleep(20000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                catch (Exception e) {
                    log.error(ExceptionUtil.getStackTrace((Exception)e));
                }
                break;
            }
        }
    }

    public abstract String getJsonValue(String var1);
}

