/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance;

import io.runon.cryptocurrency.exchanges.ExchangeWebSocketListener;
import io.runon.cryptocurrency.exchanges.binance.BinanceExchange;
import io.runon.cryptocurrency.trading.CryptocurrencyTrade;
import io.runon.cryptocurrency.trading.DataStreamTrade;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.trading.Trade;
import okhttp3.WebSocket;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinanceTradeStream<T extends CryptocurrencyTrade>
extends DataStreamTrade<T> {
    private static final Logger log = LoggerFactory.getLogger(BinanceTradeStream.class);
    protected String wssAddress = "wss://stream.binance.com:9443/ws";
    private ExchangeWebSocketListener webSocketListener = null;
    private String subscribeMessage = "{\"method\":\"SUBSCRIBE\",\"id\":1,\"params\":[\"btcusdt@aggTrade\"]}";

    public BinanceTradeStream(String streamId) {
        super(streamId);
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void connect() {
        this.close();
        this.webSocketListener = new ExchangeWebSocketListener(this.streamId, this.wssAddress, this.subscribeMessage){

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                if (this.isClose()) {
                    return;
                }
                try {
                    JSONObject messageObj = new JSONObject(text);
                    if (messageObj.isNull("e")) {
                        log.debug(text);
                        return;
                    }
                    if (!messageObj.getString("e").equals("aggTrade")) {
                        log.debug(text);
                        return;
                    }
                    BinanceTradeStream.this.addTrade(messageObj.getString("s"), new Trade(Trade.Type.NONE, messageObj.getBigDecimal("p"), messageObj.getBigDecimal("q"), System.currentTimeMillis()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.webSocketListener.connect();
    }

    public void close() {
        try {
            if (this.webSocketListener != null) {
                this.webSocketListener.close();
                this.webSocketListener = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        return BinanceExchange.getMarketSymbol(cryptocurrencyId);
    }
}

