/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance.account;

import com.binance.client.RequestOptions;
import com.binance.client.SyncRequestClient;
import com.binance.client.model.enums.NewOrderRespType;
import com.binance.client.model.enums.OrderSide;
import com.binance.client.model.enums.OrderType;
import com.binance.client.model.market.ExchangeInfoEntry;
import com.binance.client.model.market.ExchangeInformation;
import com.binance.client.model.market.MarkPrice;
import com.binance.client.model.trade.AccountInformation;
import com.binance.client.model.trade.Order;
import io.runon.cryptocurrency.exchanges.binance.BinanceExchange;
import io.runon.cryptocurrency.exchanges.binance.BinanceFuturesApis;
import io.runon.trading.Trade;
import io.runon.trading.account.FuturesPosition;
import io.runon.trading.account.FuturesTradeAccount;
import io.runon.trading.exception.MinOrderException;
import io.runon.trading.exception.SymbolNotFoundException;
import io.runon.trading.order.LimitOrder;
import io.runon.trading.order.LimitOrderTrade;
import io.runon.trading.order.MarketOrderTrade;
import io.runon.trading.order.MarketOrderTradeData;
import io.runon.trading.strategy.Position;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BinanceFuturesAccount
implements FuturesTradeAccount,
LimitOrder {
    private final SyncRequestClient syncRequestClient;
    private final String id;
    private final BigDecimal fee = new BigDecimal("0.0004");
    private final Map<String, BigDecimal> symbolPriceMap = new HashMap<String, BigDecimal>();
    private final Object symbolPriceLock = new Object();
    private String market = "USDT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrice(String symbol, BigDecimal price) {
        Object object = this.symbolPriceLock;
        synchronized (object) {
            this.symbolPriceMap.put(symbol, price);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getPrice(String symbol) {
        Object object = this.symbolPriceLock;
        synchronized (object) {
            return this.symbolPriceMap.get(symbol);
        }
    }

    public BinanceFuturesAccount(String apiKey, String secretKey) {
        RequestOptions options = new RequestOptions();
        this.syncRequestClient = SyncRequestClient.create((String)apiKey, (String)secretKey, (RequestOptions)options);
        this.id = "binance_futures";
    }

    public BinanceFuturesAccount(String id, String apiKey, String secretKey) {
        RequestOptions options = new RequestOptions();
        this.syncRequestClient = SyncRequestClient.create((String)apiKey, (String)secretKey, (RequestOptions)options);
        this.id = id;
    }

    public BinanceFuturesAccount(SyncRequestClient syncRequestClient) {
        this.syncRequestClient = syncRequestClient;
        this.id = "binance_futures";
    }

    public BinanceFuturesAccount(String id, SyncRequestClient syncRequestClient) {
        this.syncRequestClient = syncRequestClient;
        this.id = id;
    }

    public FuturesPosition getPosition(String symbol) {
        return BinanceFuturesApis.getPosition(symbol, this.syncRequestClient.getAccountInformation());
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public String getId() {
        return this.id;
    }

    public BigDecimal getAssets() {
        AccountInformation accountInformation = this.syncRequestClient.getAccountInformation();
        return BinanceFuturesApis.getUsdtAsset(accountInformation);
    }

    public BigDecimal getCash() {
        AccountInformation accountInformation = this.syncRequestClient.getAccountInformation();
        return BinanceFuturesApis.getUsdtCash(accountInformation);
    }

    public SyncRequestClient getSyncRequestClient() {
        return this.syncRequestClient;
    }

    public AccountInformation getAccountInformation() {
        return this.syncRequestClient.getAccountInformation();
    }

    public void setLeverage(String symbol, BigDecimal leverage) {
        this.syncRequestClient.changeInitialLeverage(symbol, Integer.valueOf(leverage.intValue()));
    }

    public BigDecimal getLeverage(String symbol) {
        FuturesPosition futuresPosition = this.getPosition(symbol);
        return futuresPosition.getLeverage();
    }

    public BigDecimal getAvailableBuyPrice(String symbol) {
        BigDecimal price = this.getCash();
        FuturesPosition futuresPosition = this.getPosition(symbol);
        if (futuresPosition != null && futuresPosition.getPosition() == Position.SHORT) {
            price = price.add(futuresPosition.getTradingPrice().multiply(new BigDecimal("0.9")));
        }
        return price.subtract(price.multiply(this.fee));
    }

    public BigDecimal getAvailableSellPrice(String symbol) {
        BigDecimal price = this.getCash();
        FuturesPosition futuresPosition = this.getPosition(symbol);
        if (futuresPosition != null && futuresPosition.getPosition() == Position.LONG) {
            price = price.add(futuresPosition.getTradingPrice().multiply(new BigDecimal("0.9")));
        }
        return price.subtract(price.multiply(this.fee));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarketOrderTrade orderQuantity(String symbol, Trade.Type type, BigDecimal quantity) {
        BigDecimal lastClosePrice;
        Object object = this.symbolPriceLock;
        synchronized (object) {
            lastClosePrice = this.symbolPriceMap.get(symbol);
        }
        return this.orderQuantity(symbol, type, quantity, lastClosePrice);
    }

    public MarketOrderTrade orderQuantity(String symbol, Trade.Type type, BigDecimal quantity, BigDecimal lastClosePrice) {
        symbol = BinanceExchange.getSymbolMarket(symbol, this.market);
        long orderTime = System.currentTimeMillis();
        Order order = this.syncRequestClient.postOrder(symbol, OrderSide.valueOf((String)type.toString()), null, OrderType.MARKET, null, quantity.toString(), null, null, null, null, null, NewOrderRespType.RESULT);
        long closeTime = System.currentTimeMillis();
        BigDecimal leverage = this.getLeverage(symbol);
        MarketOrderTradeData marketPriceOrderData = new MarketOrderTradeData();
        marketPriceOrderData.setTradeType(type);
        marketPriceOrderData.setQuantity(order.getExecutedQty());
        marketPriceOrderData.setTradePrice(BinanceFuturesApis.getTradePrice(order, 2));
        marketPriceOrderData.setLastClosePrice(lastClosePrice);
        marketPriceOrderData.setFee(marketPriceOrderData.getTradePrice().multiply(this.fee));
        marketPriceOrderData.setOrderTime(orderTime);
        marketPriceOrderData.setCloseTime(closeTime);
        return marketPriceOrderData;
    }

    public MarketOrderTrade orderCash(String symbol, Trade.Type type, BigDecimal cash) {
        symbol = BinanceExchange.getSymbolMarket(symbol, this.market);
        ExchangeInformation exchangeInformation = this.syncRequestClient.getExchangeInformation();
        List symbols = exchangeInformation.getSymbols();
        ExchangeInfoEntry symbolEntry = null;
        for (ExchangeInfoEntry entry : symbols) {
            if (!entry.getSymbol().equals(symbol)) continue;
            symbolEntry = entry;
            break;
        }
        if (symbolEntry == null) {
            throw new SymbolNotFoundException(symbol);
        }
        Long quantityPrecision = symbolEntry.getQuantityPrecision();
        BigDecimal currentPrice = ((MarkPrice)this.syncRequestClient.getMarkPrice(symbol).get(0)).getMarkPrice();
        BigDecimal quantity = cash.divide(currentPrice, quantityPrecision.intValue(), RoundingMode.DOWN);
        if (quantity.compareTo(BigDecimal.ZERO) <= 0) {
            BigDecimal dividedNum = new BigDecimal(1);
            int i = 0;
            while ((long)i < quantityPrecision) {
                dividedNum = dividedNum.multiply(new BigDecimal(10));
                ++i;
            }
            String message = "Binance Future [" + symbol + "] price '" + cash + "' is lower. min dollar is [" + currentPrice.divide(dividedNum, 2, RoundingMode.UP).stripTrailingZeros().toPlainString() + "]";
            throw new MinOrderException(message);
        }
        return this.orderQuantity(symbol, type, quantity, currentPrice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarketOrderTrade closePosition(String symbol) {
        OrderSide orderSide;
        BigDecimal lastClosePrice;
        Object object = this.symbolPriceLock;
        synchronized (object) {
            lastClosePrice = this.symbolPriceMap.get(symbol);
        }
        AccountInformation accountInformation = this.syncRequestClient.getAccountInformation();
        com.binance.client.model.trade.Position symbolPosition = BinanceFuturesApis.getBinancePosition(symbol, accountInformation);
        BigDecimal quantity = symbolPosition.getPositionAmt();
        if (quantity.compareTo(BigDecimal.ZERO) == 0) {
            return MarketOrderTrade.EMPTY_MARKET_ORDER;
        }
        if (quantity.compareTo(BigDecimal.ZERO) > 0) {
            orderSide = OrderSide.SELL;
        } else {
            quantity = quantity.multiply(new BigDecimal(-1));
            orderSide = OrderSide.BUY;
        }
        long orderTime = System.currentTimeMillis();
        Order order = this.syncRequestClient.postOrder(symbol, orderSide, null, OrderType.MARKET, null, quantity.toString(), null, "true", null, null, null, NewOrderRespType.RESULT);
        long closeTime = System.currentTimeMillis();
        MarketOrderTradeData marketPriceOrderData = new MarketOrderTradeData();
        marketPriceOrderData.setTradeType(Trade.Type.valueOf((String)orderSide.toString()));
        marketPriceOrderData.setQuantity(quantity);
        marketPriceOrderData.setTradePrice(BinanceFuturesApis.getTradePrice(order, 2));
        marketPriceOrderData.setLastClosePrice(lastClosePrice);
        marketPriceOrderData.setFee(marketPriceOrderData.getTradePrice().multiply(this.fee));
        marketPriceOrderData.setOrderTime(orderTime);
        marketPriceOrderData.setCloseTime(closeTime);
        return marketPriceOrderData;
    }

    public LimitOrderTrade[] limitOrderQuantity(String symbol, Trade.Type type, BigDecimal quantity, BigDecimal limitPrice) {
        return new LimitOrderTrade[0];
    }

    public LimitOrderTrade[] limitOrderCash(String symbol, Trade.Type type, BigDecimal cash, BigDecimal limitPrice) {
        return new LimitOrderTrade[0];
    }

    public LimitOrderTrade[] limitOrderCash(String symbol, Trade.Type type, BigDecimal cash, BigDecimal beginPrice, BigDecimal endPrice, BigDecimal priceGap) {
        return new LimitOrderTrade[0];
    }
}

