/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance.trade.information;

import com.binance.client.model.trade.AccountInformation;
import com.binance.client.model.trade.Leverage;
import com.binance.client.model.trade.Position;
import io.runon.cryptocurrency.exchanges.binance.trade.api.BinanceApiManager;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountInformationSupport {
    AccountInformation accountInformation;
    private Map<String, BigDecimal> symbolLeverageMap;

    private AccountInformationSupport() {
        this.updateAccountInformation();
    }

    public static AccountInformationSupport getInstance() {
        return SingleTonHolder.INSTANCE;
    }

    private void updateSymbolLeverageMap() {
        this.symbolLeverageMap = new HashMap<String, BigDecimal>();
        List positions = this.accountInformation.getPositions();
        for (Position position : positions) {
            this.symbolLeverageMap.put(position.getSymbol(), position.getLeverage());
        }
    }

    public void updateSymbolLeverage(String symbol, BigDecimal leverage) {
        Leverage changeLeverage = BinanceApiManager.getInstance().getApi().changeInitialLeverage(symbol, Integer.valueOf(leverage.intValue()));
        this.symbolLeverageMap.put(symbol, leverage);
    }

    public void updateAccountInformation() {
        this.accountInformation = BinanceApiManager.getInstance().getApi().getAccountInformation();
        this.updateSymbolLeverageMap();
    }

    public BigDecimal getLeverage(String symbol) {
        return this.symbolLeverageMap.get(symbol);
    }

    public BigDecimal getLiveLeverage(String symbol) {
        this.updateAccountInformation();
        return this.symbolLeverageMap.get(symbol);
    }

    public AccountInformation getAccountInformation() {
        return this.accountInformation;
    }

    public AccountInformation getLiveAccountInformation() {
        this.updateAccountInformation();
        return this.accountInformation;
    }

    private static class SingleTonHolder {
        private static final AccountInformationSupport INSTANCE = new AccountInformationSupport();

        private SingleTonHolder() {
        }
    }
}

