/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance.trade.information;

import com.binance.client.model.market.ExchangeInfoEntry;
import com.binance.client.model.market.ExchangeInformation;
import com.binance.client.model.market.MarkPrice;
import io.runon.cryptocurrency.exchanges.binance.trade.api.BinanceApiManager;
import io.runon.cryptocurrency.exchanges.binance.trade.exception.BinanceFuturesOrderLowerException;
import io.runon.cryptocurrency.exchanges.binance.trade.exception.BinanceFuturesSymbolNotFoundException;
import io.runon.cryptocurrency.exchanges.binance.trade.information.AccountInformationSupport;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExchangeInformationSupport {
    ExchangeInformation exchangeInformation = BinanceApiManager.getInstance().getApi().getExchangeInformation();
    Map<String, ExchangeInfoEntry> symbolMap;

    private ExchangeInformationSupport() {
        this.symbolMapSetting(this.exchangeInformation);
    }

    public static ExchangeInformationSupport getInstance() {
        return SingleTonHolder.INSTANCE;
    }

    private void symbolMapSetting(ExchangeInformation information) {
        this.symbolMap = new HashMap<String, ExchangeInfoEntry>();
        List symbols = information.getSymbols();
        for (ExchangeInfoEntry symbol : symbols) {
            this.symbolMap.put(symbol.getSymbol(), symbol);
        }
    }

    public ExchangeInfoEntry getSymbol(String symbol) {
        return this.symbolMap.get(symbol);
    }

    public BigDecimal getQuantityPrice(String symbol, BigDecimal dollar) throws BinanceFuturesSymbolNotFoundException, BinanceFuturesOrderLowerException {
        ExchangeInfoEntry exchangeInfoEntry = this.symbolMap.get(symbol);
        if (exchangeInfoEntry == null) {
            throw new BinanceFuturesSymbolNotFoundException(symbol);
        }
        Long quantityPrecision = exchangeInfoEntry.getQuantityPrecision();
        BigDecimal currentPrice = this.getMarketPrice(symbol);
        BigDecimal leverage = AccountInformationSupport.getInstance().getLeverage(symbol);
        BigDecimal quantity = dollar.divide(currentPrice, quantityPrecision.intValue(), RoundingMode.DOWN);
        if (quantity.compareTo(BigDecimal.ZERO) <= 0) {
            BigDecimal dividedNum = new BigDecimal(1);
            int i = 0;
            while ((long)i < quantityPrecision) {
                dividedNum = dividedNum.multiply(new BigDecimal(10));
                ++i;
            }
            String message = "Binance Future [" + symbol + "] price '" + dollar + "', leverage '" + leverage + "' is lower. min dollar is [" + currentPrice.divide(dividedNum, 2, RoundingMode.UP).toString() + "]";
            throw new BinanceFuturesOrderLowerException(message);
        }
        return quantity;
    }

    private BigDecimal getMarketPrice(String symbol) {
        List markPrices = BinanceApiManager.getInstance().getApi().getMarkPrice(symbol);
        return ((MarkPrice)markPrices.get(0)).getMarkPrice();
    }

    private static class SingleTonHolder {
        private static final ExchangeInformationSupport INSTANCE = new ExchangeInformationSupport();

        private SingleTonHolder() {
        }
    }
}

