/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.binance.trade.trade;

import com.binance.client.SyncRequestClient;
import com.binance.client.model.ResponseResult;
import com.binance.client.model.enums.NewOrderRespType;
import com.binance.client.model.enums.OrderSide;
import com.binance.client.model.enums.OrderType;
import com.binance.client.model.trade.AccountInformation;
import com.binance.client.model.trade.Order;
import com.binance.client.model.trade.Position;
import io.runon.cryptocurrency.exchanges.binance.trade.api.BinanceApiManager;
import io.runon.cryptocurrency.exchanges.binance.trade.exception.BinanceFuturesOrderLowerException;
import io.runon.cryptocurrency.exchanges.binance.trade.exception.BinanceFuturesSymbolNotFoundException;
import io.runon.cryptocurrency.exchanges.binance.trade.information.AccountInformationSupport;
import io.runon.cryptocurrency.exchanges.binance.trade.information.ExchangeInformationSupport;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinanceFutureTrade {
    private static final Logger log = LoggerFactory.getLogger(BinanceFutureTrade.class);
    private static final SyncRequestClient api = BinanceApiManager.getInstance().getApi();
    private static final AccountInformationSupport account = AccountInformationSupport.getInstance();
    private static final ExchangeInformationSupport exchange = ExchangeInformationSupport.getInstance();

    public static Order longOrderByMarket(String symbol, BigDecimal quantity) throws BinanceFuturesSymbolNotFoundException, BinanceFuturesOrderLowerException {
        return BinanceFutureTrade.postOrder(symbol, null, quantity, null, null, OrderSide.BUY);
    }

    public static Order longOrder(String symbol, BigDecimal quantity, String price) throws BinanceFuturesSymbolNotFoundException, BinanceFuturesOrderLowerException {
        return BinanceFutureTrade.postOrder(symbol, null, quantity, null, price, OrderSide.BUY);
    }

    public static Order dollarLongOrder(String symbol, String dollar, String price) throws BinanceFuturesSymbolNotFoundException, BinanceFuturesOrderLowerException {
        return BinanceFutureTrade.postOrder(symbol, new BigDecimal(dollar), null, null, price, OrderSide.BUY);
    }

    public static Order shortOrderByMarket(String symbol, BigDecimal quantity) throws BinanceFuturesSymbolNotFoundException, BinanceFuturesOrderLowerException {
        return BinanceFutureTrade.postOrder(symbol, null, quantity, null, null, OrderSide.SELL);
    }

    public static Order shortOrder(String symbol, BigDecimal quantity, String price) throws BinanceFuturesSymbolNotFoundException, BinanceFuturesOrderLowerException {
        return BinanceFutureTrade.postOrder(symbol, null, quantity, null, price, OrderSide.SELL);
    }

    public static Order dollarShortOrder(String symbol, String dollar, String price) throws BinanceFuturesSymbolNotFoundException, BinanceFuturesOrderLowerException {
        return BinanceFutureTrade.postOrder(symbol, new BigDecimal(dollar), null, null, price, OrderSide.SELL);
    }

    public static Order closeAllPositionsByMarket(String symbol) {
        return BinanceFutureTrade.closeAllPositions(symbol, null);
    }

    public static Order closeAllPositions(String symbol, String price) {
        OrderSide orderSide;
        AccountInformation accountInformation = account.getLiveAccountInformation();
        BigDecimal quantity = new BigDecimal(0);
        List positions = accountInformation.getPositions();
        for (Position position : positions) {
            if (!position.getSymbol().equals(symbol)) continue;
            quantity = position.getPositionAmt();
            break;
        }
        if (quantity.compareTo(new BigDecimal(0)) > 0) {
            orderSide = OrderSide.SELL;
        } else {
            quantity = quantity.multiply(new BigDecimal(-1));
            orderSide = OrderSide.BUY;
        }
        if (quantity.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        log.info("[" + symbol + "] \uccad\uc0b0 : \uac00\uaca9[" + price + "] \uc2dc\uc7a5\uac00\uc5ec\ubd80[" + (price == null) + "] \uc218\ub7c9[" + quantity.toPlainString() + "] \ub871/\uc20f[" + orderSide.name() + "]");
        return api.postOrder(symbol, orderSide, null, price == null ? OrderType.MARKET : OrderType.LIMIT, null, quantity.toString(), price, "true", null, null, null, NewOrderRespType.RESULT);
    }

    public static Order postOrder(String symbol, BigDecimal dollar, BigDecimal quantity, String orderId, String price, OrderSide orderSide) throws BinanceFuturesSymbolNotFoundException, BinanceFuturesOrderLowerException {
        if (quantity == null) {
            quantity = exchange.getQuantityPrice(symbol, dollar);
        }
        log.info("[" + symbol + "] \uc8fc\ubb38 : \uac00\uaca9[" + price + "] \uc2dc\uc7a5\uac00\uc5ec\ubd80[" + (price == null) + "] \uc218\ub7c9[" + quantity.toString() + "] \ub871/\uc20f[" + orderSide.name() + "]");
        return api.postOrder(symbol, orderSide, null, price == null ? OrderType.MARKET : OrderType.LIMIT, null, quantity.toString(), price, null, orderId, null, null, NewOrderRespType.RESULT);
    }

    public static List<Order> getOpenOrders(String symbol) {
        return api.getOpenOrders(symbol);
    }

    public static ResponseResult cancelAllOrders(String symbol) {
        return api.cancelAllOpenOrder(symbol);
    }
}

