/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.bithumb;

import io.runon.cryptocurrency.exchanges.DelimiterMarketSymbol;
import io.runon.cryptocurrency.exchanges.ExchangeWebSocketListener;
import io.runon.cryptocurrency.trading.CryptocurrencyTrade;
import io.runon.cryptocurrency.trading.DataStreamTrade;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.trading.Trade;
import okhttp3.WebSocket;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BithumbTradeStream<T extends CryptocurrencyTrade>
extends DataStreamTrade<T> {
    private static final Logger log = LoggerFactory.getLogger(BithumbTradeStream.class);
    private ExchangeWebSocketListener webSocketListener = null;
    private String subscribeMessage = "{\"type\":\"transaction\", \"symbols\":[\"BTC_KRW\"]}";

    public BithumbTradeStream(String streamId) {
        super(streamId);
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void connect() {
        this.close();
        this.webSocketListener = new ExchangeWebSocketListener(this.streamId, "wss://pubwss.bithumb.com/pub/ws", this.subscribeMessage){

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                if (this.isClose()) {
                    return;
                }
                try {
                    JSONObject obj = new JSONObject(text);
                    if (obj.isNull("type") || !obj.getString("type").equals("transaction")) {
                        return;
                    }
                    JSONArray array = obj.getJSONObject("content").getJSONArray("list");
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject object = array.getJSONObject(i);
                        Trade.Type type = object.getString("buySellGb").equals("2") ? Trade.Type.BUY : Trade.Type.SELL;
                        BithumbTradeStream.this.addTrade(object.getString("symbol"), new Trade(type, object.getBigDecimal("contPrice"), object.getBigDecimal("contQty"), System.currentTimeMillis()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.webSocketListener.connect();
    }

    public void close() {
        try {
            if (this.webSocketListener != null) {
                this.webSocketListener.close();
                this.webSocketListener = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        return DelimiterMarketSymbol.leftSymbol("_", cryptocurrencyId);
    }
}

