/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.coinbase;

import com.seomse.commons.utils.ExceptionUtil;
import io.runon.cryptocurrency.exchanges.DelimiterMarketSymbol;
import io.runon.cryptocurrency.exchanges.ExchangeWebSocketListener;
import io.runon.cryptocurrency.trading.CryptocurrencyTrade;
import io.runon.cryptocurrency.trading.DataStreamTrade;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.trading.Trade;
import okhttp3.WebSocket;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CoinbaseTradeStream<T extends CryptocurrencyTrade>
extends DataStreamTrade<T> {
    private static final Logger log = LoggerFactory.getLogger(CoinbaseTradeStream.class);
    private ExchangeWebSocketListener webSocketListener = null;
    private String subscribeMessage = "{\"type\":\"subscribe\",\"channels\":[{\"name\":\"ticker\",\"product_ids\":[\"BTC-USD\"]}]}";

    public CoinbaseTradeStream(String streamId) {
        super(streamId);
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void connect() {
        this.close();
        this.webSocketListener = new ExchangeWebSocketListener(this.streamId, "wss://ws-feed.exchange.coinbase.com", this.subscribeMessage){

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                if (this.isClose()) {
                    return;
                }
                try {
                    Trade.Type tradeType;
                    JSONObject object = new JSONObject(text);
                    if (!object.getString("type").equals("ticker")) {
                        log.debug(text);
                        return;
                    }
                    String side = object.getString("side").toLowerCase();
                    if (side.equals("buy")) {
                        tradeType = Trade.Type.BUY;
                    } else if (side.equals("sell")) {
                        tradeType = Trade.Type.SELL;
                    } else {
                        log.error("side check: " + side);
                        return;
                    }
                    String id = object.getString("product_id");
                    Trade trade = new Trade(tradeType, object.getBigDecimal("price"), object.getBigDecimal("last_size"), System.currentTimeMillis());
                    CoinbaseTradeStream.this.addTrade(id, trade);
                }
                catch (Exception e) {
                    log.error(ExceptionUtil.getStackTrace((Exception)e));
                }
            }
        };
        this.webSocketListener.connect();
    }

    public MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        return DelimiterMarketSymbol.leftSymbol("-", cryptocurrencyId);
    }

    public void close() {
        try {
            if (this.webSocketListener != null) {
                this.webSocketListener.close();
                this.webSocketListener = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

