/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.ftx;

import io.runon.cryptocurrency.exchanges.ExchangeWebSocketListener;
import io.runon.cryptocurrency.exchanges.ftx.FtxExchange;
import io.runon.cryptocurrency.trading.CryptocurrencyTrade;
import io.runon.cryptocurrency.trading.DataStreamTrade;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.trading.Trade;
import okhttp3.WebSocket;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FtxTradeStream<T extends CryptocurrencyTrade>
extends DataStreamTrade<T> {
    private static final Logger log = LoggerFactory.getLogger(FtxTradeStream.class);
    private ExchangeWebSocketListener webSocketListener = null;
    private String[] subscribeMessages = new String[]{"{\"channel\":\"trades\",\"op\":\"subscribe\",\"market\":\"BTC/USDT\"}"};

    public FtxTradeStream(String streamId) {
        super(streamId);
    }

    public void setSubscribeMessage(String subscribeMessage) {
        String[] subscribeMessages = new String[]{subscribeMessage};
        this.subscribeMessages = subscribeMessages;
    }

    public void setSubscribeMessage(String[] subscribeMessages) {
        this.subscribeMessages = subscribeMessages;
    }

    public void connect() {
        this.close();
        this.webSocketListener = new ExchangeWebSocketListener(this.streamId, "wss://ftx.com/ws", this.subscribeMessages){

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                if (this.isClose()) {
                    return;
                }
                try {
                    JSONObject obj = new JSONObject(text);
                    if (!obj.getString("type").equals("update")) {
                        return;
                    }
                    String id = obj.getString("market");
                    JSONArray array = new JSONArray(obj.getJSONArray("data"));
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject data = array.getJSONObject(i);
                        Trade.Type type = data.getString("side").equals("buy") ? Trade.Type.BUY : Trade.Type.SELL;
                        FtxTradeStream.this.addTrade(id, new Trade(type, data.getBigDecimal("price"), data.getBigDecimal("size"), System.currentTimeMillis()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.webSocketListener.connect();
    }

    public MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        return FtxExchange.getMarketSymbol(cryptocurrencyId);
    }

    public void close() {
        try {
            if (this.webSocketListener != null) {
                this.webSocketListener.close();
                this.webSocketListener = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

