/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.huobi;

import com.alibaba.fastjson.JSONObject;
import com.huobi.client.req.market.SubMarketTradeRequest;
import com.huobi.constant.HuobiOptions;
import com.huobi.constant.Options;
import com.huobi.model.market.MarketTradeEvent;
import com.huobi.service.huobi.connection.HuobiWebSocketConnection;
import com.huobi.service.huobi.parser.HuobiModelParser;
import com.huobi.service.huobi.parser.market.MarketTradeEventParser;
import com.huobi.utils.InputChecker;
import com.huobi.utils.ResponseCallback;
import com.huobi.utils.SymbolUtils;
import com.seomse.commons.utils.ExceptionUtil;
import io.runon.cryptocurrency.exchanges.huobi.HoubiExchange;
import io.runon.cryptocurrency.trading.CryptocurrencyTrade;
import io.runon.cryptocurrency.trading.DataStreamTrade;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.trading.Trade;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HuobiTradeStream<T extends CryptocurrencyTrade>
extends DataStreamTrade<T> {
    private static final Logger log = LoggerFactory.getLogger(HuobiTradeStream.class);
    private String subscribeMessage = "btcusdt";
    private HuobiWebSocketConnection huobiWebSocketConnection = null;
    private boolean isErrorExtract = true;

    public HuobiTradeStream(String streamId) {
        super(streamId);
    }

    public MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        return HoubiExchange.getMarketSymbol(cryptocurrencyId);
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void connect() {
        this.isErrorExtract = true;
        this.close();
        try {
            this.subscribe(SubMarketTradeRequest.builder().symbol(this.subscribeMessage).build(), (ResponseCallback<MarketTradeEvent>)((ResponseCallback)tradeEvent -> {
                String id = tradeEvent.getCh().split("\\.")[1];
                tradeEvent.getList().forEach(marketTrade -> {
                    block6: {
                        try {
                            Trade.Type tradeType;
                            String direction = marketTrade.getDirection();
                            if (direction.equals("buy")) {
                                tradeType = Trade.Type.BUY;
                            } else if (direction.equals("sell")) {
                                tradeType = Trade.Type.SELL;
                            } else {
                                log.error("direction check: " + direction);
                                return;
                            }
                            Trade trade = new Trade(tradeType, marketTrade.getPrice(), marketTrade.getAmount(), System.currentTimeMillis());
                            this.addTrade(id, trade);
                        }
                        catch (Exception e) {
                            if (!this.isErrorExtract) break block6;
                            this.isErrorExtract = false;
                            log.error(ExceptionUtil.getStackTrace((Exception)e));
                        }
                    }
                });
            }));
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getStackTrace((Exception)e));
        }
    }

    private void subscribe(SubMarketTradeRequest request, ResponseCallback<MarketTradeEvent> callback) {
        InputChecker.checker().shouldNotNull((Object)request.getSymbol(), "symbol");
        List symbolList = SymbolUtils.parseSymbols((String)request.getSymbol());
        InputChecker.checker().checkSymbolList(symbolList);
        ArrayList commandList = new ArrayList(symbolList.size());
        symbolList.forEach(symbol -> {
            String topic = "market.$symbol.trade.detail".replace("$symbol", (CharSequence)symbol);
            JSONObject command = new JSONObject();
            command.put("sub", (Object)topic);
            command.put("id", (Object)System.nanoTime());
            commandList.add(command.toJSONString());
        });
        this.huobiWebSocketConnection = HuobiWebSocketConnection.createMarketConnection((Options)new HuobiOptions(), commandList, (HuobiModelParser)new MarketTradeEventParser(), callback, (boolean)false);
        this.huobiWebSocketConnection.setErrorCallback(obj -> log.error(obj.toString() + "\nhuobi error"));
    }

    public void close() {
        if (this.huobiWebSocketConnection != null) {
            try {
                this.huobiWebSocketConnection.close();
                this.huobiWebSocketConnection = null;
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getStackTrace((Exception)e));
            }
        }
    }
}

