/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.kraken;

import com.seomse.commons.utils.ExceptionUtil;
import io.runon.cryptocurrency.exchanges.ExchangeWebSocketListener;
import io.runon.cryptocurrency.exchanges.TradeConverter;
import io.runon.cryptocurrency.trading.CryptocurrencyTrade;
import io.runon.cryptocurrency.trading.DataStreamTrade;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.trading.Trade;
import okhttp3.WebSocket;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KrakenFuturesTradeStream<T extends CryptocurrencyTrade>
extends DataStreamTrade<T> {
    private static final Logger log = LoggerFactory.getLogger(KrakenFuturesTradeStream.class);
    private ExchangeWebSocketListener webSocketListener;
    private String subscribeMessage = "{\"event\":\"subscribe\",\"feed\":\"trade\",\"product_ids\":[\"PI_XBTUSD\"]}";
    private TradeConverter converter = null;

    public KrakenFuturesTradeStream(String streamId) {
        super(streamId);
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void setConverter(TradeConverter converter) {
        this.converter = converter;
    }

    public void connect() {
        this.close();
        this.webSocketListener = new ExchangeWebSocketListener(this.streamId, "wss://futures.kraken.com/ws/v1", this.subscribeMessage){

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                if (this.isClose()) {
                    return;
                }
                KrakenFuturesTradeStream.this.lastTime = System.currentTimeMillis();
                try {
                    Trade.Type type;
                    JSONObject object = new JSONObject(text);
                    if (object.has("event")) {
                        return;
                    }
                    if (!object.getString("feed").equals("trade")) {
                        return;
                    }
                    String id = object.getString("product_id");
                    String side = object.getString("side");
                    if (side.equals("buy")) {
                        type = Trade.Type.BUY;
                    } else if (side.equals("sell")) {
                        type = Trade.Type.SELL;
                    } else {
                        return;
                    }
                    Trade trade = new Trade(type, object.getBigDecimal("price"), object.getBigDecimal("qty"), System.currentTimeMillis());
                    if (KrakenFuturesTradeStream.this.converter != null) {
                        KrakenFuturesTradeStream.this.converter.convert(trade);
                    }
                    KrakenFuturesTradeStream.this.addTrade(id, trade);
                }
                catch (Exception e) {
                    log.error(ExceptionUtil.getStackTrace((Exception)e));
                }
            }
        };
        this.webSocketListener.connect();
    }

    public void close() {
        try {
            if (this.webSocketListener != null) {
                this.webSocketListener.close();
                this.webSocketListener = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        MarketSymbol marketSymbol = new MarketSymbol();
        marketSymbol.setId(cryptocurrencyId);
        int index = cryptocurrencyId.indexOf(95);
        if (index != -1) {
            cryptocurrencyId = cryptocurrencyId.substring(index + 1);
        }
        marketSymbol.setMarket("USD");
        marketSymbol.setSymbol(cryptocurrencyId.substring(0, cryptocurrencyId.length() - 3));
        return marketSymbol;
    }
}

