/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.kraken;

import com.seomse.commons.utils.ExceptionUtil;
import io.runon.cryptocurrency.exchanges.DelimiterMarketSymbol;
import io.runon.cryptocurrency.exchanges.ExchangeWebSocketListener;
import io.runon.cryptocurrency.trading.CryptocurrencyTrade;
import io.runon.cryptocurrency.trading.DataStreamTrade;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.trading.Trade;
import okhttp3.WebSocket;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KrakenTradeStream<T extends CryptocurrencyTrade>
extends DataStreamTrade<T> {
    private static final Logger log = LoggerFactory.getLogger(KrakenTradeStream.class);
    private ExchangeWebSocketListener webSocketListener;
    private String subscribeMessage = "{\"event\":\"subscribe\",\"subscription\":{\"name\":\"trade\"},\"pair\":[\"XBT/USD\"]}";

    public KrakenTradeStream(String streamId) {
        super(streamId);
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void connect() {
        this.close();
        this.webSocketListener = new ExchangeWebSocketListener(this.streamId, "wss://ws.kraken.com", this.subscribeMessage){

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                if (this.isClose()) {
                    return;
                }
                KrakenTradeStream.this.lastTime = System.currentTimeMillis();
                try {
                    if (!text.startsWith("[")) {
                        return;
                    }
                    JSONArray array = new JSONArray(text);
                    if (!array.getString(2).equals("trade")) {
                        return;
                    }
                    String id = array.getString(3);
                    array = array.getJSONArray(1);
                    for (int i = 0; i < array.length(); ++i) {
                        Trade.Type type;
                        JSONArray row = array.getJSONArray(i);
                        String side = row.getString(3);
                        if (side.equals("b")) {
                            type = Trade.Type.BUY;
                        } else {
                            if (!side.equals("s")) continue;
                            type = Trade.Type.SELL;
                        }
                        KrakenTradeStream.this.addTrade(id, new Trade(type, row.getBigDecimal(0), row.getBigDecimal(1), System.currentTimeMillis()));
                    }
                }
                catch (Exception e) {
                    log.error(ExceptionUtil.getStackTrace((Exception)e));
                }
            }
        };
        this.webSocketListener.connect();
    }

    public void close() {
        try {
            if (this.webSocketListener != null) {
                this.webSocketListener.close();
                this.webSocketListener = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        return DelimiterMarketSymbol.leftSymbol("/", cryptocurrencyId);
    }
}

