/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.okx;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.seomse.crawling.core.http.HttpUrl;
import java.util.ArrayList;
import java.util.Collection;
import org.json.JSONArray;
import org.json.JSONObject;

public class OkxExchange {
    public static String getTickers() {
        return OkxExchange.getTickers("SPOT");
    }

    public static String getTickers(String type) {
        return HttpUrl.get((String)("https://www.okx.com/api/v5/market/tickers?instType=" + type));
    }

    public static String[] getIds(String symbol, String option) {
        String value = OkxExchange.getTickers(option);
        JSONObject obj = new JSONObject(value);
        JSONArray array = obj.getJSONArray("data");
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            obj = array.getJSONObject(i);
            String id = obj.getString("instId");
            if (!id.startsWith(symbol + "-")) continue;
            idList.add(id);
        }
        return idList.toArray(new String[0]);
    }

    public static String getTradeSubscribeMessage(String ids) {
        return OkxExchange.getTradeSubscribeMessage(ids.split(","));
    }

    public static String getTradeSubscribeMessage(Collection<String> ids) {
        return OkxExchange.getTradeSubscribeMessage(ids.toArray(new String[0]));
    }

    public static String getTradeSubscribeMessage(String[] ids) {
        Gson gson = new Gson();
        JsonObject messageObj = new JsonObject();
        messageObj.addProperty("op", "subscribe");
        JsonArray args = new JsonArray();
        for (String id : ids) {
            JsonObject idObj = new JsonObject();
            idObj.addProperty("channel", "trades");
            idObj.addProperty("instId", id);
            args.add((JsonElement)idObj);
        }
        messageObj.add("args", (JsonElement)args);
        return gson.toJson((JsonElement)messageObj);
    }
}

