/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.okx;

import io.runon.cryptocurrency.exchanges.DelimiterMarketSymbol;
import io.runon.cryptocurrency.exchanges.ExchangeWebSocketListener;
import io.runon.cryptocurrency.exchanges.TradeConverter;
import io.runon.cryptocurrency.trading.CryptocurrencyTrade;
import io.runon.cryptocurrency.trading.DataStreamTrade;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.trading.Trade;
import java.math.BigDecimal;
import okhttp3.WebSocket;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class OkxTradeStream<T extends CryptocurrencyTrade>
extends DataStreamTrade<T> {
    private ExchangeWebSocketListener webSocketListener = null;
    private String subscribeMessage = "{\"op\":\"subscribe\",\"args\":[{\"channel\":\"trades\",\"instId\":\"BTC-USDT\"}]}";
    private TradeConverter converter = null;

    public OkxTradeStream(String streamId) {
        super(streamId);
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void setConverter(TradeConverter converter) {
        this.converter = converter;
    }

    public void connect() {
        this.close();
        this.webSocketListener = new ExchangeWebSocketListener(this.streamId, "wss://ws.okex.com:8443/ws/v5/public", this.subscribeMessage){

            @Override
            public void onMessage(WebSocket webSocket, String text) {
                if (this.isClose()) {
                    return;
                }
                try {
                    JSONObject object = new JSONObject(text);
                    if (object.isNull("arg")) {
                        return;
                    }
                    JSONObject arg = object.getJSONObject("arg");
                    if (arg.isNull("channel")) {
                        return;
                    }
                    if (!arg.getString("channel").equals("trades")) {
                        return;
                    }
                    JSONArray data = object.getJSONArray("data");
                    for (int i = 0; i < data.length(); ++i) {
                        JSONObject tradeObj = data.getJSONObject(i);
                        String id = tradeObj.getString("instId");
                        BigDecimal volume = tradeObj.getBigDecimal("sz");
                        Trade.Type type = tradeObj.getString("side").equals("buy") ? Trade.Type.BUY : Trade.Type.SELL;
                        Trade trade = new Trade(type, tradeObj.getBigDecimal("px"), volume, System.currentTimeMillis());
                        if (OkxTradeStream.this.converter != null) {
                            OkxTradeStream.this.converter.convert(trade);
                        }
                        OkxTradeStream.this.addTrade(id, trade);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.webSocketListener.connect();
    }

    public MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        return DelimiterMarketSymbol.getMarketSymbol("-", cryptocurrencyId, 1, 0);
    }

    public void close() {
        try {
            if (this.webSocketListener != null) {
                this.webSocketListener.close();
                this.webSocketListener = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

