/*
 * Decompiled with CFR 0.152.
 */
package io.runon.cryptocurrency.exchanges.upbit;

import io.runon.cryptocurrency.exchanges.DelimiterMarketSymbol;
import io.runon.cryptocurrency.exchanges.ExchangeWebSocketHandler;
import io.runon.cryptocurrency.trading.CryptocurrencyTrade;
import io.runon.cryptocurrency.trading.DataStreamTrade;
import io.runon.cryptocurrency.trading.MarketSymbol;
import io.runon.trading.Trade;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.json.JSONObject;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public abstract class UpbitTradeStream<T extends CryptocurrencyTrade>
extends DataStreamTrade<T> {
    private ExchangeWebSocketHandler webSocketHandler = null;
    private String subscribeMessage = "[{\"ticket\":\"price\"},{\"type\":\"ticker\",\"codes\":[\"KRW-BTC\"]}]";

    public UpbitTradeStream(String streamId) {
        super(streamId);
    }

    public void setSubscribeMessage(String subscribeMessage) {
        this.subscribeMessage = subscribeMessage;
    }

    public void connect() {
        this.close();
        this.webSocketHandler = new ExchangeWebSocketHandler(this.streamId, "wss://api.upbit.com/websocket/v1", this.subscribeMessage){

            @Override
            public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) {
                if (this.isClose()) {
                    return;
                }
                try {
                    ByteBuffer heapByteBuffer = (ByteBuffer)message.getPayload();
                    byte[] array = heapByteBuffer.array();
                    JSONObject ticket = new JSONObject(new String(array, StandardCharsets.UTF_8));
                    if (ticket.getBoolean("is_trading_suspended")) {
                        return;
                    }
                    Trade.Type type = ticket.getString("ask_bid").equals("BID") ? Trade.Type.BUY : Trade.Type.SELL;
                    UpbitTradeStream.this.addTrade(ticket.getString("code"), new Trade(type, ticket.getBigDecimal("trade_price"), ticket.getBigDecimal("trade_volume"), System.currentTimeMillis()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.webSocketHandler.connect();
    }

    public void close() {
        try {
            if (this.webSocketHandler != null) {
                this.webSocketHandler.close();
                this.webSocketHandler = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MarketSymbol getMarketSymbol(String cryptocurrencyId) {
        return DelimiterMarketSymbol.rightSymbol("-", cryptocurrencyId);
    }
}

