/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.component.impl.resolver;

import com.google.inject.Inject;
import io.rxmicro.annotation.processor.common.component.ModelFieldBuilder;
import io.rxmicro.annotation.processor.common.model.ModelFieldBuilderOptions;
import io.rxmicro.annotation.processor.common.model.ModelFieldType;
import io.rxmicro.annotation.processor.common.model.error.InternalErrorException;
import io.rxmicro.annotation.processor.common.model.error.InterruptProcessingException;
import io.rxmicro.annotation.processor.common.util.Annotations;
import io.rxmicro.annotation.processor.common.util.validators.VariableDefinitionValidators;
import io.rxmicro.annotation.processor.data.sql.component.SQLVariableValueResolver;
import io.rxmicro.annotation.processor.data.sql.component.impl.DbObjectNameBuilder;
import io.rxmicro.annotation.processor.data.sql.component.impl.resolver.SQLVariableValueCalculatorProvider;
import io.rxmicro.annotation.processor.data.sql.model.DbObjectName;
import io.rxmicro.annotation.processor.data.sql.model.ParsedSQL;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataModelField;
import io.rxmicro.annotation.processor.data.sql.model.SQLDataObjectModelClass;
import io.rxmicro.annotation.processor.data.sql.model.SQLMethodDescriptor;
import io.rxmicro.annotation.processor.data.sql.model.VariableContext;
import io.rxmicro.annotation.processor.data.sql.model.VariableValuesMap;
import io.rxmicro.common.util.Formats;
import io.rxmicro.data.sql.SupportedVariables;
import io.rxmicro.data.sql.VariableValues;
import io.rxmicro.data.sql.operation.Delete;
import io.rxmicro.data.sql.operation.Insert;
import io.rxmicro.data.sql.operation.Select;
import io.rxmicro.data.sql.operation.Update;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public abstract class AbstractSQLVariableValueResolver<A extends Annotation, DMF extends SQLDataModelField, DMC extends SQLDataObjectModelClass<DMF>>
implements SQLVariableValueResolver<A, DMF, DMC> {
    private final Map<TypeElement, DMC> modelClassesCache = new HashMap<TypeElement, DMC>();
    @Inject
    private ModelFieldBuilder<DMF, DMC> modelFieldModelFieldBuilder;
    @Inject
    private DbObjectNameBuilder dbObjectNameBuilder;

    @Override
    public final VariableValuesMap resolveVariableValues(VariableContext variableContext, ParsedSQL<A> parsedSQL, ExecutableElement method, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor) {
        SQLDataObjectModelClass modelClass;
        VariableValuesMap globalVariableValuesMap = new VariableValuesMap();
        VariableValuesMap localVariableValuesMap = new VariableValuesMap();
        VariableValuesMap entityVariableValuesMap = new VariableValuesMap();
        Optional.ofNullable(method.getEnclosingElement().getAnnotation(VariableValues.class)).map(VariableValues::value).ifPresent(v -> this.setVariables(method.getEnclosingElement(), globalVariableValuesMap, (String)v));
        boolean found = false;
        if (this.isSupportEntityResult() && sqlMethodDescriptor.getEntityResult().isPresent()) {
            modelClass = (SQLDataObjectModelClass)((Object)sqlMethodDescriptor.getEntityResult().get());
            this.putVariableValues(variableContext, modelClass, entityVariableValuesMap, this.getSupportedResultsVariables());
            found = true;
        }
        if (this.isSupportEntityParam() && sqlMethodDescriptor.getEntityParam().isPresent()) {
            modelClass = (SQLDataObjectModelClass)((Object)sqlMethodDescriptor.getEntityParam().get());
            this.putVariableValues(variableContext, modelClass, entityVariableValuesMap, this.getSupportedParamsVariables());
            found = true;
        }
        this.putVariableValuesIfAnnotationClassPresent(variableContext, parsedSQL, method, sqlMethodDescriptor, entityVariableValuesMap, found);
        Optional.ofNullable(method.getAnnotation(VariableValues.class)).map(VariableValues::value).ifPresent(v -> this.setVariables(method, localVariableValuesMap, (String)v));
        return this.mergeVariableValuesMaps(method, globalVariableValuesMap, localVariableValuesMap, entityVariableValuesMap);
    }

    private void putVariableValuesIfAnnotationClassPresent(VariableContext variableContext, ParsedSQL<A> parsedSQL, ExecutableElement method, SQLMethodDescriptor<DMF, DMC> sqlMethodDescriptor, VariableValuesMap entityVariableValuesMap, boolean foundEntity) {
        Optional entityTypeElement = Annotations.getAnnotationClassParameter(() -> this.getEntityClass(parsedSQL));
        if (entityTypeElement.isPresent()) {
            if (foundEntity) {
                throw new InterruptProcessingException((Element)method, "@?.entityClass() is redundant annotation parameter. Current entity detected using method parameters or method result. Remove this parameter!", new Object[]{parsedSQL.getAnnotation().annotationType().getSimpleName()});
            }
            SQLDataObjectModelClass modelClass = this.modelClassesCache.computeIfAbsent((TypeElement)entityTypeElement.get(), t -> (SQLDataObjectModelClass)((Object)((Object)this.modelFieldModelFieldBuilder.build(ModelFieldType.UNDEFINED, sqlMethodDescriptor.getCurrentModule(), Set.of(t), ModelFieldBuilderOptions.DEFAULT_OPTIONS).get(t))));
            this.putVariableValues(variableContext, modelClass, entityVariableValuesMap, this.getSupportedParamsVariables());
            this.putVariableValues(variableContext, modelClass, entityVariableValuesMap, this.getSupportedResultsVariables());
        }
    }

    private void putVariableValues(VariableContext variableContext, DMC modelClass, VariableValuesMap entityVariableValuesMap, Set<String> supportedVariables) {
        DbObjectName tableName = this.dbObjectNameBuilder.buildTableName(modelClass.getModelTypeElement());
        variableContext.setCurrentTableName(tableName);
        for (String variableName : supportedVariables) {
            BiFunction<SQLDataObjectModelClass<?>, VariableContext, Object> provider = SQLVariableValueCalculatorProvider.VARIABLE_RESOLVER_PROVIDER.get(variableName);
            if (provider == null) {
                throw new InternalErrorException("Variable provider not found for variable: '?'", new Object[]{variableName});
            }
            entityVariableValuesMap.put(variableName, provider.apply((SQLDataObjectModelClass<?>)((Object)modelClass), variableContext));
        }
        variableContext.releaseCurrentTable();
    }

    protected abstract Set<String> getSupportedParamsVariables();

    protected abstract Set<String> getSupportedResultsVariables();

    protected boolean isSupportEntityParam() {
        return true;
    }

    protected boolean isSupportEntityResult() {
        return true;
    }

    protected abstract Class<?> getEntityClass(ParsedSQL<A> var1);

    private void setVariables(Element owner, VariableValuesMap variableValuesMap, String ... variables) {
        VariableDefinitionValidators.validateThatVariablesContainEvenItemCount((Element)owner, VariableValues.class, (String)"value", (String[])variables);
        for (int i = 0; i < variables.length; i += 2) {
            String variableName = variables[i];
            VariableDefinitionValidators.validateVariableNameFormat((Element)owner, VariableValues.class, (String)"value", (String)variableName);
            String variableValue = variables[i + 1];
            this.validateVariableValue(owner, variableValuesMap, variableName, variableValue);
            variableValuesMap.put(variableName, variableValue);
        }
    }

    private void validateVariableValue(Element owner, VariableValuesMap variableValuesMap, String variableName, String variableValue) {
        if (variableValuesMap.containsKey(variableName)) {
            throw new InterruptProcessingException(owner, "Variable definition '? = ?' is redundant. Remove it!", new Object[]{variableName, variableValue});
        }
        if (variableValue.contains(Formats.FORMAT_PLACEHOLDER_TOKEN) && SupportedVariables.ALL_SUPPORTED_VARIABLES.contains(variableName)) {
            throw new InterruptProcessingException(owner, "Variable definition '? = ?' couldn't contain universal placeholder: '?'. Only static values are supported now! For dynamic values use 'entityClass' parameter that available for '@?', '@?', '@?' and '@?' annotations!", new Object[]{variableName, variableValue, "?", Insert.class.getSimpleName(), Update.class.getSimpleName(), Delete.class.getSimpleName(), Select.class.getSimpleName()});
        }
    }

    private VariableValuesMap mergeVariableValuesMaps(ExecutableElement method, VariableValuesMap globalVariableValuesMap, VariableValuesMap localVariableValuesMap, VariableValuesMap entityVariableValuesMap) {
        localVariableValuesMap.forEach((k, v) -> {
            if (entityVariableValuesMap.containsKey(k)) {
                throw new InterruptProcessingException((Element)method, "Local variable definition '? = ?' is redundant. Remove it!", new Object[]{k, v});
            }
        });
        VariableValuesMap variableValuesMap = new VariableValuesMap(globalVariableValuesMap);
        localVariableValuesMap.forEach(variableValuesMap::put);
        entityVariableValuesMap.forEach(variableValuesMap::put);
        return variableValuesMap;
    }
}

