/*
 * Decompiled with CFR 0.152.
 */
package io.rxmicro.annotation.processor.data.sql.model;

import io.rxmicro.common.util.ExCollections;
import io.rxmicro.common.util.Requires;
import java.lang.annotation.Annotation;
import java.util.List;

public final class ParsedSQL<T extends Annotation> {
    private final T annotation;
    private final List<String> sqlTokens;

    public ParsedSQL(T annotation, List<String> sqlTokens) {
        this.annotation = (Annotation)Requires.require(annotation);
        this.sqlTokens = ExCollections.unmodifiableList(sqlTokens);
    }

    public T getAnnotation() {
        return this.annotation;
    }

    public List<String> getSqlTokens() {
        return this.sqlTokens;
    }

    public boolean doesNotContain(String token) {
        return this.sqlTokens.stream().noneMatch(v -> v.equalsIgnoreCase(token));
    }
}

