/*
 * Copyright (c) 2020. https://rxmicro.io
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.rxmicro.http.client.jdk.internal;

import io.rxmicro.config.Secrets;
import io.rxmicro.http.client.HttpClient;
import io.rxmicro.http.client.HttpClientConfig;
import io.rxmicro.http.client.HttpClientContentConverter;
import io.rxmicro.http.client.HttpClientFactory;

/**
 * @author nedis
 * @since 0.1
 */
public final class JdkHttpClientFactory implements HttpClientFactory {

    @Override
    public HttpClient create(final Class<?> loggerClass,
                             final HttpClientConfig httpClientConfig,
                             final Secrets secrets,
                             final HttpClientContentConverter contentConverter) {
        return new JdkHttpClient(loggerClass, httpClientConfig, secrets, contentConverter);
    }
}
