/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.mongo;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.MongoDatabase;
import java.util.Objects;

public class MongoConfigConnector {
    private final MongoDatabase database;
    private final MongoClientURI clientUri;

    private MongoConfigConnector(Builder builder) {
        this.database = builder.database;
        this.clientUri = builder.clientUri;
    }

    public MongoDatabase getDatabase() {
        return this.database;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "MongoConfigConnector{database=" + this.clientUri + '}';
    }

    public static class Builder {
        private MongoDatabase database;
        private MongoClientURI clientUri;

        public Builder forUri(String uri) {
            this.clientUri = new MongoClientURI(uri);
            String databaseName = this.clientUri.getDatabase();
            Objects.requireNonNull(databaseName, "Mongo uri must contain database");
            this.database = new MongoClient(this.clientUri).getDatabase(databaseName);
            return this;
        }

        public MongoConfigConnector build() {
            return new MongoConfigConnector(this);
        }
    }
}

