/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.mongo;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.scalecube.config.audit.ConfigEvent;
import io.scalecube.config.audit.ConfigEventListener;
import io.scalecube.config.mongo.MongoConfigConnector;
import io.scalecube.config.mongo.MongoConfigObjectMapper;
import io.scalecube.config.utils.ThrowableUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Collectors;
import org.bson.RawBsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoConfigEventListener
implements ConfigEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoConfigEventListener.class);
    private static final ThreadFactory threadFactory = r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("mongo-config-auditor");
        thread.setUncaughtExceptionHandler((t, e) -> LOGGER.error("Exception occurred: " + e, e));
        return thread;
    };
    private static final Executor executor = Executors.newSingleThreadExecutor(threadFactory);
    private final MongoConfigConnector connector;
    private final String collectionName;

    public MongoConfigEventListener(MongoConfigConnector connector, String collectionName) {
        this.connector = connector;
        this.collectionName = collectionName;
    }

    public void onEvents(Collection<ConfigEvent> events) {
        CompletableFuture.runAsync(() -> {
            ObjectMapper objectMapper = MongoConfigObjectMapper.getInstance();
            this.connector.getDatabase().getCollection(this.collectionName, RawBsonDocument.class).insertMany(events.stream().map(event -> {
                AuditLogEntity entity = new AuditLogEntity();
                entity.setName(event.getName());
                entity.setTimestamp(event.getTimestamp());
                entity.setHost(event.getHost());
                entity.setType(event.getType().toString());
                entity.setNewSource(event.getNewSource());
                entity.setNewOrigin(event.getNewOrigin());
                entity.setNewValue(event.getNewValue());
                entity.setOldSource(event.getOldSource());
                entity.setOldOrigin(event.getOldOrigin());
                entity.setOldValue(event.getOldValue());
                return entity;
            }).map(entity -> {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    objectMapper.writer().writeValue((OutputStream)baos, entity);
                }
                catch (Exception e) {
                    LOGGER.error("Exception at converting obj: {} to bson, cause: {}", entity, (Object)e);
                    throw ThrowableUtil.propagate((Throwable)e);
                }
                return new RawBsonDocument(baos.toByteArray());
            }).collect(Collectors.toList()));
        }, executor);
    }

    private static class AuditLogEntity {
        private String name;
        private Date timestamp;
        private String type;
        private String host;
        private String oldSource;
        private String oldOrigin;
        private String oldValue;
        private String newSource;
        private String newOrigin;
        private String newValue;

        private AuditLogEntity() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getOldSource() {
            return this.oldSource;
        }

        public void setOldSource(String oldSource) {
            this.oldSource = oldSource;
        }

        public String getOldOrigin() {
            return this.oldOrigin;
        }

        public void setOldOrigin(String oldOrigin) {
            this.oldOrigin = oldOrigin;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public void setOldValue(String oldValue) {
            this.oldValue = oldValue;
        }

        public String getNewSource() {
            return this.newSource;
        }

        public void setNewSource(String newSource) {
            this.newSource = newSource;
        }

        public String getNewOrigin() {
            return this.newOrigin;
        }

        public void setNewOrigin(String newOrigin) {
            this.newOrigin = newOrigin;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public void setNewValue(String newValue) {
            this.newValue = newValue;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("AuditLogEntity{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", timestamp=").append(this.timestamp);
            sb.append(", type='").append(this.type).append('\'');
            sb.append(", host='").append(this.host).append('\'');
            sb.append(", oldSource='").append(this.oldSource).append('\'');
            sb.append(", oldOrigin='").append(this.oldOrigin).append('\'');
            sb.append(", oldValue='").append(this.oldValue).append('\'');
            sb.append(", newSource='").append(this.newSource).append('\'');
            sb.append(", newOrigin='").append(this.newOrigin).append('\'');
            sb.append(", newValue='").append(this.newValue).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }
}

