/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.config.mongo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import io.scalecube.config.keyvalue.KeyValueConfigEntity;
import io.scalecube.config.keyvalue.KeyValueConfigName;
import io.scalecube.config.keyvalue.KeyValueConfigRepository;
import io.scalecube.config.mongo.MongoConfigConnector;
import io.scalecube.config.mongo.MongoConfigObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.RawBsonDocument;

public class MongoConfigRepository
implements KeyValueConfigRepository {
    private final MongoConfigConnector connector;

    public MongoConfigRepository(MongoConfigConnector connector) {
        this.connector = Objects.requireNonNull(connector);
    }

    public List<KeyValueConfigEntity> findAll(KeyValueConfigName configName) throws Exception {
        Objects.requireNonNull(configName);
        String collectionName = configName.getQualifiedName();
        MongoCollection collection = this.connector.getDatabase().getCollection(collectionName, RawBsonDocument.class);
        MongoCursor it = collection.find().iterator();
        if (!it.hasNext()) {
            return Collections.emptyList();
        }
        RawBsonDocument document = (RawBsonDocument)it.next();
        ByteArrayInputStream bin = new ByteArrayInputStream(document.getByteBuffer().array());
        ObjectMapper objectMapper = MongoConfigObjectMapper.getInstance();
        ObjectReader objectReader = objectMapper.readerFor(MongoConfigEntity.class);
        List<KeyValueConfigEntity> result = ((MongoConfigEntity)objectReader.readValue((InputStream)bin)).getConfig();
        return result.stream().map(input -> input.setConfigName(configName)).collect(Collectors.toList());
    }

    private static class MongoConfigEntity {
        private List<KeyValueConfigEntity> config;

        public List<KeyValueConfigEntity> getConfig() {
            return this.config;
        }

        public void setConfig(List<KeyValueConfigEntity> config) {
            this.config = config;
        }
    }
}

