/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.gossip;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.scalecube.cluster.Member;
import io.scalecube.cluster.gossip.Gossip;
import io.scalecube.cluster.gossip.GossipRequest;
import io.scalecube.transport.Address;
import io.scalecube.transport.Message;
import io.scalecube.transport.MessageCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Fork(value=2)
@State(value=Scope.Thread)
@Threads(value=4)
@Warmup(iterations=5)
@Measurement(iterations=5)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ProtostuffGossipBenchmark {
    static final String PAYLOAD = "Tl4KqQXZ5aMiIw29";
    static final String PAYLOAD_X32 = "tI8Ppp8ShAp7IEDSFV1IgZCDKH2WyLI0NeSNc9oQOhQZXcHOzktuQBQmT5EGNitohtS1LShvdHgtAtWRze03rXCPM1dhAGOgPjIFBFA2fQGTOlh8icxKVx8jwyFEqqehmIubcvfEFYmsb1QZgTgu2wdB4XxpTsspxUq4pc0O124AsU61W9tw7LZWlhij1EA44sPrfjgW9kIZCEf8HL2zOXMUyNqRdzXD2VlxerrW7X8jcbYSCn5jkkXsc0E5Hf7P5DcuEcASrGH3ZhaGv94pnSneX9BJrRIQxtmAdPPUXzVXrKw0mYcoB6Ye8mWuvVUFOO1Io6NJk0q2HHKST0FQVQo6mVEYKm8geTI6WphB4uRiQ6ksk6zOrJXmwQ6ssJIPYRRF2Mx9EDR9OMhYw6hoijdfgd23EXz8WkTkYz42kQkK99rNxyIXVMVyRPzLHBclYaYKlcmoN8f7hq6aiv3VxlPPchZ6xWmjOlGJY9P7nINtChd2spMUkhAeznajS4VW";
    Message gossipReq;
    ByteBuf gossipReqSer;
    ByteBuf bbGossipReq;
    Message gossipReqx32;
    ByteBuf gossipReqx32Ser;
    ByteBuf bbGossipReqx32;

    @Setup
    public void setup() {
        ImmutableList gossips = ImmutableList.of((Object)new Gossip("ABCDEFGH_0", Message.fromData((Object)PAYLOAD_X32)));
        Member from = new Member("0", Address.from((String)"localhost:1234"));
        this.gossipReq = Message.fromData((Object)new GossipRequest((List)gossips, from.id()));
        this.gossipReqSer = Unpooled.buffer((int)1024);
        MessageCodec.serialize((Message)this.gossipReq, (ByteBuf)this.gossipReqSer);
        this.bbGossipReq = Unpooled.buffer((int)1024);
        System.err.println("### gossipReqSer=" + this.gossipReqSer);
        ArrayList<Gossip> list32 = new ArrayList<Gossip>();
        for (int i = 0; i < 32; ++i) {
            list32.add(new Gossip("ABCDEFGH_" + i, Message.fromData((Object)PAYLOAD)));
        }
        this.gossipReqx32 = Message.fromData((Object)new GossipRequest(list32, from.id()));
        this.gossipReqx32Ser = Unpooled.buffer((int)1024);
        MessageCodec.serialize((Message)this.gossipReqx32, (ByteBuf)this.gossipReqx32Ser);
        this.bbGossipReqx32 = Unpooled.buffer((int)1024);
        System.err.println("### gossipReqx32Ser=" + this.gossipReqx32Ser);
    }

    @Benchmark
    public void ser() {
        MessageCodec.serialize((Message)this.gossipReq, (ByteBuf)this.bbGossipReq.resetWriterIndex());
    }

    @Benchmark
    public void deser() {
        MessageCodec.deserialize((ByteBuf)this.gossipReqSer.resetReaderIndex());
    }

    @Benchmark
    public void ser_x32() {
        MessageCodec.serialize((Message)this.gossipReqx32, (ByteBuf)this.bbGossipReqx32.resetWriterIndex());
    }

    @Benchmark
    public void deser_x32() {
        MessageCodec.deserialize((ByteBuf)this.gossipReqx32Ser.resetReaderIndex());
    }
}

