/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.scalecube.transport.Message;
import io.scalecube.transport.MessageCodec;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Fork(value=2)
@State(value=Scope.Thread)
@Threads(value=4)
@Warmup(iterations=5)
@Measurement(iterations=5)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ProtostuffMessageBenchmark {
    static final String PAYLOAD = "SgUKzpnrt8ArR9jz";
    static final String PAYLOAD_X16 = "M82qEG06ucgawpZ89PgJcBhWiDIOZgEgz8o42ZuBrXVEXlUNmXfPdY1BOh4UbbwxTuTNAeyosxlZjDOfEfxPKPM2Al5CVkpg5175hzLBV5afcocm52JKwDvgSKVkoMzvnVWIQfjeAgGIERBgJ7a63mGygKDQS4moeHryedn68mmzNHGYbSqp7PIb6Rbn8SgT1hSOATWBReLA4ZPqfGUV0miIgOU90EYXffu9aT4cc9V8rsz3q4W8ibMsxq1JMsB6";
    Message msg;
    ByteBuf msgSer;
    ByteBuf bbMsg;
    Message msgx16;
    ByteBuf msgx16Ser;
    ByteBuf bbMsgx16;

    @Setup
    public void setup() {
        this.msg = Message.fromData((Object)PAYLOAD);
        this.msgSer = Unpooled.buffer((int)1024);
        MessageCodec.serialize((Message)this.msg, (ByteBuf)this.msgSer);
        this.bbMsg = Unpooled.buffer((int)1024);
        System.err.println("### msgSer=" + this.msgSer);
        this.msgx16 = Message.fromData((Object)PAYLOAD_X16);
        this.msgx16Ser = Unpooled.buffer((int)1024);
        MessageCodec.serialize((Message)this.msgx16, (ByteBuf)this.msgx16Ser);
        this.bbMsgx16 = Unpooled.buffer((int)1024);
        System.err.println("### msgx16Ser=" + this.msgx16Ser);
    }

    @Benchmark
    public void ser() {
        MessageCodec.serialize((Message)this.msg, (ByteBuf)this.bbMsg.resetWriterIndex());
    }

    @Benchmark
    public void deser() {
        MessageCodec.deserialize((ByteBuf)this.msgSer.resetReaderIndex());
    }

    @Benchmark
    public void ser_x16() {
        MessageCodec.serialize((Message)this.msgx16, (ByteBuf)this.bbMsgx16.resetWriterIndex());
    }

    @Benchmark
    public void deser_x16() {
        MessageCodec.deserialize((ByteBuf)this.msgx16Ser.resetReaderIndex());
    }
}

