/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster;

import io.scalecube.cluster.fdetector.FailureDetectorConfig;
import io.scalecube.cluster.gossip.GossipConfig;
import io.scalecube.cluster.membership.MembershipConfig;
import io.scalecube.cluster.metadata.MetadataCodec;
import io.scalecube.cluster.transport.api.TransportConfig;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import reactor.core.Exceptions;

public final class ClusterConfig
implements Cloneable {
    public static final int DEFAULT_METADATA_TIMEOUT = 3000;
    public static final int DEFAULT_WAN_METADATA_TIMEOUT = 10000;
    public static final int DEFAULT_LOCAL_METADATA_TIMEOUT = 1000;
    private Object metadata;
    private int metadataTimeout = 3000;
    private MetadataCodec metadataCodec = MetadataCodec.INSTANCE;
    private String memberId;
    private String memberAlias;
    private String externalHost;
    private Integer externalPort;
    private TransportConfig transportConfig = TransportConfig.defaultConfig();
    private FailureDetectorConfig failureDetectorConfig = FailureDetectorConfig.defaultConfig();
    private GossipConfig gossipConfig = GossipConfig.defaultConfig();
    private MembershipConfig membershipConfig = MembershipConfig.defaultConfig();

    public static ClusterConfig defaultConfig() {
        return new ClusterConfig();
    }

    public static ClusterConfig defaultLanConfig() {
        return ClusterConfig.defaultConfig();
    }

    public static ClusterConfig defaultWanConfig() {
        return ClusterConfig.defaultConfig().failureDetector(opts -> FailureDetectorConfig.defaultWanConfig()).gossip(opts -> GossipConfig.defaultWanConfig()).membership(opts -> MembershipConfig.defaultWanConfig()).transport(opts -> TransportConfig.defaultWanConfig()).metadataTimeout(10000);
    }

    public static ClusterConfig defaultLocalConfig() {
        return ClusterConfig.defaultConfig().failureDetector(opts -> FailureDetectorConfig.defaultLocalConfig()).gossip(opts -> GossipConfig.defaultLocalConfig()).membership(opts -> MembershipConfig.defaultLocalConfig()).transport(opts -> TransportConfig.defaultLocalConfig()).metadataTimeout(1000);
    }

    public <T> T metadata() {
        return (T)this.metadata;
    }

    public ClusterConfig metadata(Object metadata) {
        ClusterConfig c = this.clone();
        c.metadata = metadata;
        return c;
    }

    public int metadataTimeout() {
        return this.metadataTimeout;
    }

    public ClusterConfig metadataTimeout(int metadataTimeout) {
        ClusterConfig c = this.clone();
        c.metadataTimeout = metadataTimeout;
        return c;
    }

    public MetadataCodec metadataCodec() {
        return this.metadataCodec;
    }

    public ClusterConfig metadataCodec(MetadataCodec metadataCodec) {
        ClusterConfig c = this.clone();
        c.metadataCodec = metadataCodec;
        return c;
    }

    public String externalHost() {
        return this.externalHost;
    }

    public ClusterConfig externalHost(String externalHost) {
        ClusterConfig c = this.clone();
        c.externalHost = externalHost;
        return c;
    }

    public String memberId() {
        return this.memberId;
    }

    public ClusterConfig memberId(String memberId) {
        ClusterConfig c = this.clone();
        c.memberId = memberId;
        return c;
    }

    public String memberAlias() {
        return this.memberAlias;
    }

    public ClusterConfig memberAlias(String memberAlias) {
        ClusterConfig c = this.clone();
        c.memberAlias = memberAlias;
        return c;
    }

    public Integer externalPort() {
        return this.externalPort;
    }

    public ClusterConfig externalPort(Integer externalPort) {
        ClusterConfig c = this.clone();
        c.externalPort = externalPort;
        return c;
    }

    public ClusterConfig transport(UnaryOperator<TransportConfig> op) {
        ClusterConfig c = this.clone();
        c.transportConfig = (TransportConfig)op.apply(this.transportConfig);
        return c;
    }

    public TransportConfig transportConfig() {
        return this.transportConfig;
    }

    public ClusterConfig failureDetector(UnaryOperator<FailureDetectorConfig> op) {
        ClusterConfig c = this.clone();
        c.failureDetectorConfig = (FailureDetectorConfig)op.apply(this.failureDetectorConfig);
        return c;
    }

    public FailureDetectorConfig failureDetectorConfig() {
        return this.failureDetectorConfig;
    }

    public ClusterConfig gossip(UnaryOperator<GossipConfig> op) {
        ClusterConfig c = this.clone();
        c.gossipConfig = (GossipConfig)op.apply(this.gossipConfig);
        return c;
    }

    public GossipConfig gossipConfig() {
        return this.gossipConfig;
    }

    public ClusterConfig membership(UnaryOperator<MembershipConfig> op) {
        ClusterConfig c = this.clone();
        c.membershipConfig = (MembershipConfig)op.apply(this.membershipConfig);
        return c;
    }

    public MembershipConfig membershipConfig() {
        return this.membershipConfig;
    }

    public ClusterConfig clone() {
        try {
            ClusterConfig c = (ClusterConfig)super.clone();
            c.transportConfig = this.transportConfig.clone();
            c.failureDetectorConfig = this.failureDetectorConfig.clone();
            c.gossipConfig = this.gossipConfig.clone();
            c.membershipConfig = this.membershipConfig.clone();
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String toString() {
        return new StringJoiner(", ", ClusterConfig.class.getSimpleName() + "[", "]").add("metadata=" + this.metadataAsString()).add("metadataTimeout=" + this.metadataTimeout).add("metadataCodec=" + String.valueOf(this.metadataCodec)).add("memberId='" + this.memberId + "'").add("memberAlias='" + this.memberAlias + "'").add("externalHost='" + this.externalHost + "'").add("externalPort=" + this.externalPort).add("transportConfig=" + String.valueOf(this.transportConfig)).add("failureDetectorConfig=" + String.valueOf(this.failureDetectorConfig)).add("gossipConfig=" + String.valueOf(this.gossipConfig)).add("membershipConfig=" + String.valueOf(this.membershipConfig)).toString();
    }

    private String metadataAsString() {
        return Optional.ofNullable(this.metadata).map(Object::hashCode).map(Integer::toHexString).orElse(null);
    }
}

