/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.cluster.membership;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import reactor.core.Exceptions;

public final class MembershipConfig
implements Cloneable {
    public static final int DEFAULT_SYNC_INTERVAL = 30000;
    public static final int DEFAULT_SYNC_TIMEOUT = 3000;
    public static final int DEFAULT_SUSPICION_MULT = 5;
    public static final int DEFAULT_WAN_SUSPICION_MULT = 6;
    public static final int DEFAULT_WAN_SYNC_INTERVAL = 60000;
    public static final int DEFAULT_LOCAL_SUSPICION_MULT = 3;
    public static final int DEFAULT_LOCAL_SYNC_INTERVAL = 15000;
    private List<String> seedMembers = Collections.emptyList();
    private int syncInterval = 30000;
    private int syncTimeout = 3000;
    private int suspicionMult = 5;
    private String namespace = "default";

    public static MembershipConfig defaultConfig() {
        return new MembershipConfig();
    }

    public static MembershipConfig defaultLanConfig() {
        return MembershipConfig.defaultConfig();
    }

    public static MembershipConfig defaultWanConfig() {
        return MembershipConfig.defaultConfig().suspicionMult(6).syncInterval(60000);
    }

    public static MembershipConfig defaultLocalConfig() {
        return MembershipConfig.defaultConfig().suspicionMult(3).syncInterval(15000);
    }

    public List<String> seedMembers() {
        return this.seedMembers;
    }

    public MembershipConfig seedMembers(String ... seedMembers) {
        return this.seedMembers(Arrays.asList(seedMembers));
    }

    public MembershipConfig seedMembers(List<String> seedMembers) {
        MembershipConfig m = this.clone();
        m.seedMembers = Collections.unmodifiableList(new ArrayList<String>(seedMembers));
        return m;
    }

    public int syncInterval() {
        return this.syncInterval;
    }

    public MembershipConfig syncInterval(int syncInterval) {
        MembershipConfig m = this.clone();
        m.syncInterval = syncInterval;
        return m;
    }

    public int syncTimeout() {
        return this.syncTimeout;
    }

    public MembershipConfig syncTimeout(int syncTimeout) {
        MembershipConfig m = this.clone();
        m.syncTimeout = syncTimeout;
        return m;
    }

    public int suspicionMult() {
        return this.suspicionMult;
    }

    public MembershipConfig suspicionMult(int suspicionMult) {
        MembershipConfig m = this.clone();
        m.suspicionMult = suspicionMult;
        return m;
    }

    public String namespace() {
        return this.namespace;
    }

    public MembershipConfig namespace(String namespace) {
        MembershipConfig m = this.clone();
        m.namespace = namespace;
        return m;
    }

    public MembershipConfig clone() {
        try {
            return (MembershipConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public String toString() {
        return new StringJoiner(", ", MembershipConfig.class.getSimpleName() + "[", "]").add("seedMembers=" + String.valueOf(this.seedMembers)).add("syncInterval=" + this.syncInterval).add("syncTimeout=" + this.syncTimeout).add("suspicionMult=" + this.suspicionMult).add("namespace='" + this.namespace + "'").toString();
    }
}

